/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.Set;
import java.util.UUID;
import org.reactivestreams.Publisher;
import org.redisson.RedissonSetMultimap;
import org.redisson.api.RFuture;
import org.redisson.api.RSet;
import org.redisson.api.RSetMultimap;
import org.redisson.api.RSetMultimapReactive;
import org.redisson.api.RSetReactive;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.RedissonBaseMultimapReactive;
import org.redisson.reactive.RedissonSetReactive;
import reactor.fn.Supplier;

public class RedissonSetMultimapReactive<K, V>
extends RedissonBaseMultimapReactive<K, V>
implements RSetMultimapReactive<K, V> {
    public RedissonSetMultimapReactive(UUID id, CommandReactiveExecutor commandExecutor, String name) {
        super(new RedissonSetMultimap(commandExecutor, name), commandExecutor, name);
    }

    public RedissonSetMultimapReactive(UUID id, Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        super(new RedissonSetMultimap(codec, commandExecutor, name), codec, commandExecutor, name);
    }

    @Override
    public RSetReactive<V> get(K key) {
        RSet set = ((RSetMultimap)this.instance).get(key);
        return new RedissonSetReactive(this.codec, this.commandExecutor, set.getName(), set);
    }

    @Override
    public Publisher<Set<V>> getAll(final K key) {
        return this.reactive(new Supplier<RFuture<Set<V>>>(){

            @Override
            public RFuture<Set<V>> get() {
                return ((RSetMultimap)RedissonSetMultimapReactive.this.instance).getAllAsync(key);
            }
        });
    }

    @Override
    public Publisher<Set<V>> removeAll(final Object key) {
        return this.reactive(new Supplier<RFuture<Set<V>>>(){

            @Override
            public RFuture<Set<V>> get() {
                return ((RSetMultimap)RedissonSetMultimapReactive.this.instance).removeAllAsync(key);
            }
        });
    }

    @Override
    public Publisher<Set<V>> replaceValues(final K key, final Iterable<? extends V> values) {
        return this.reactive(new Supplier<RFuture<Set<V>>>(){

            @Override
            public RFuture<Set<V>> get() {
                return ((RSetMultimap)RedissonSetMultimapReactive.this.instance).replaceValuesAsync(key, values);
            }
        });
    }
}

