/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.jcache;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;
import org.redisson.Redisson;
import org.redisson.config.Config;
import org.redisson.jcache.JCacheManager;

public class JCachingProvider
implements CachingProvider {
    private final ConcurrentMap<ClassLoader, ConcurrentMap<URI, CacheManager>> managers = new ConcurrentHashMap<ClassLoader, ConcurrentMap<URI, CacheManager>>();
    private static final String DEFAULT_URI_PATH = "jsr107-default-config";
    private static URI defaulturi;

    @Override
    public CacheManager getCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        CacheManager oldManager;
        CacheManager manager;
        ConcurrentMap<URI, CacheManager> value;
        ConcurrentMap oldValue;
        if (uri == null) {
            uri = this.getDefaultURI();
        }
        if (uri == null) {
            throw new CacheException("Uri is not defined. Can't load default configuration");
        }
        if (classLoader == null) {
            classLoader = this.getDefaultClassLoader();
        }
        if ((oldValue = (ConcurrentMap)this.managers.putIfAbsent(classLoader, value = new ConcurrentHashMap())) != null) {
            value = oldValue;
        }
        if ((manager = (CacheManager)value.get(uri)) != null) {
            return manager;
        }
        Config config = this.loadConfig(uri);
        Redisson redisson = null;
        if (config != null) {
            redisson = (Redisson)Redisson.create(config);
        }
        if ((oldManager = value.putIfAbsent(uri, manager = new JCacheManager(redisson, classLoader, this, properties, uri))) != null) {
            if (redisson != null) {
                redisson.shutdown();
            }
            manager = oldManager;
        }
        return manager;
    }

    private Config loadConfig(URI uri) {
        Config config = null;
        try {
            URL jsonUrl = null;
            jsonUrl = DEFAULT_URI_PATH.equals(uri.getPath()) ? JCachingProvider.class.getResource("/redisson-jcache.json") : uri.toURL();
            if (jsonUrl == null) {
                throw new IOException();
            }
            config = Config.fromJSON(jsonUrl);
        }
        catch (IOException e) {
            try {
                URL yamlUrl = null;
                yamlUrl = DEFAULT_URI_PATH.equals(uri.getPath()) ? JCachingProvider.class.getResource("/redisson-jcache.yaml") : uri.toURL();
                if (yamlUrl != null) {
                    config = Config.fromYAML(yamlUrl);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return config;
    }

    @Override
    public ClassLoader getDefaultClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Override
    public URI getDefaultURI() {
        return defaulturi;
    }

    @Override
    public Properties getDefaultProperties() {
        return new Properties();
    }

    @Override
    public CacheManager getCacheManager(URI uri, ClassLoader classLoader) {
        return this.getCacheManager(uri, classLoader, this.getDefaultProperties());
    }

    @Override
    public CacheManager getCacheManager() {
        return this.getCacheManager(this.getDefaultURI(), this.getDefaultClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ConcurrentMap<ClassLoader, ConcurrentMap<URI, CacheManager>> concurrentMap = this.managers;
        synchronized (concurrentMap) {
            for (ClassLoader classLoader : this.managers.keySet()) {
                this.close(classLoader);
            }
        }
    }

    @Override
    public void close(ClassLoader classLoader) {
        Map uri2manager = (Map)this.managers.remove(classLoader);
        if (uri2manager != null) {
            for (CacheManager manager : uri2manager.values()) {
                manager.close();
            }
        }
    }

    @Override
    public void close(URI uri, ClassLoader classLoader) {
        Map uri2manager = (Map)this.managers.get(classLoader);
        if (uri2manager == null) {
            return;
        }
        CacheManager manager = (CacheManager)uri2manager.remove(uri);
        if (manager == null) {
            return;
        }
        manager.close();
        if (uri2manager.isEmpty()) {
            this.managers.remove(classLoader, Collections.emptyMap());
        }
    }

    @Override
    public boolean isSupported(OptionalFeature optionalFeature) {
        return false;
    }

    static {
        try {
            defaulturi = new URI(DEFAULT_URI_PATH);
        }
        catch (URISyntaxException e) {
            throw new CacheException(e);
        }
    }
}

