/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;

public abstract class BaseConnectionHandler<C extends RedisConnection>
extends ChannelInboundHandlerAdapter {
    final RedisClient redisClient;
    final RPromise<C> connectionPromise = new RedissonPromise<C>();
    C connection;

    public BaseConnectionHandler(RedisClient redisClient) {
        this.redisClient = redisClient;
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (this.connection == null) {
            this.connection = this.createConnection(ctx);
        }
        super.channelRegistered(ctx);
    }

    abstract C createConnection(ChannelHandlerContext var1);

    @Override
    public void channelActive(final ChannelHandlerContext ctx) throws Exception {
        RFuture future;
        final AtomicInteger commandsCounter = new AtomicInteger();
        ArrayList futures = new ArrayList();
        RedisClientConfig config = this.redisClient.getConfig();
        if (config.getPassword() != null) {
            future = ((RedisConnection)this.connection).async(RedisCommands.AUTH, config.getPassword());
            futures.add(future);
        }
        if (config.getDatabase() != 0) {
            future = ((RedisConnection)this.connection).async(RedisCommands.SELECT, config.getDatabase());
            futures.add(future);
        }
        if (config.getClientName() != null) {
            future = ((RedisConnection)this.connection).async(RedisCommands.CLIENT_SETNAME, config.getClientName());
            futures.add(future);
        }
        if (config.isReadOnly()) {
            future = ((RedisConnection)this.connection).async(RedisCommands.READONLY, new Object[0]);
            futures.add(future);
        }
        if (futures.isEmpty()) {
            ctx.fireChannelActive();
            this.connectionPromise.trySuccess(this.connection);
            return;
        }
        commandsCounter.set(futures.size());
        for (RFuture rFuture : futures) {
            rFuture.addListener(new FutureListener<Object>(){

                @Override
                public void operationComplete(Future<Object> future) throws Exception {
                    if (!future.isSuccess()) {
                        ((RedisConnection)BaseConnectionHandler.this.connection).closeAsync();
                        BaseConnectionHandler.this.connectionPromise.tryFailure(future.cause());
                        return;
                    }
                    if (commandsCounter.decrementAndGet() == 0) {
                        ctx.fireChannelActive();
                        BaseConnectionHandler.this.connectionPromise.trySuccess(BaseConnectionHandler.this.connection);
                    }
                }
            });
        }
    }
}

