/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.tagresolver;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.tagresolver.ContextPath;
import org.raml.parser.tagresolver.ContextPathAware;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.utils.StreamUtils;
import org.raml.parser.visitor.NodeHandler;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public class IncludeResolver
implements TagResolver,
ContextPathAware {
    public static final Tag INCLUDE_TAG = new Tag("!include");
    public static final String SEPARATOR = "_";
    public static final String INCLUDE_APPLIED_TAG = "!include-applied_";
    private ContextPath contextPath;

    @Override
    public boolean handles(Tag tag) {
        return INCLUDE_TAG.equals((Object)tag) || tag.startsWith(INCLUDE_APPLIED_TAG);
    }

    @Override
    public Node resolve(Node node, ResourceLoader resourceLoader, NodeHandler nodeHandler) {
        Object includeNode;
        if (node.getTag().startsWith(INCLUDE_APPLIED_TAG)) {
            return node;
        }
        if (node.getNodeId() != NodeId.scalar) {
            nodeHandler.onCustomTagError(INCLUDE_TAG, node, "Include cannot be non-scalar");
            return this.mockInclude(node);
        }
        ScalarNode scalarNode = (ScalarNode)node;
        String resourceName = this.contextPath.resolveAbsolutePath(scalarNode.getValue());
        InputStream inputStream = resourceLoader.fetchResource(resourceName);
        if (inputStream == null) {
            nodeHandler.onCustomTagError(INCLUDE_TAG, node, "Include cannot be resolved " + resourceName);
            return this.mockInclude(node);
        }
        if (resourceName.endsWith(".raml") || resourceName.endsWith(".yaml") || resourceName.endsWith(".yml")) {
            Yaml yamlParser = new Yaml();
            includeNode = yamlParser.compose((Reader)new InputStreamReader(inputStream));
        } else {
            String newValue = StreamUtils.toString(inputStream);
            includeNode = new IncludeScalarNode(resourceName, newValue, scalarNode);
        }
        if (includeNode == null) {
            nodeHandler.onCustomTagError(INCLUDE_TAG, node, "Include file is empty " + resourceName);
            return this.mockInclude(node);
        }
        String markInfo = node.getStartMark().getLine() + SEPARATOR + node.getStartMark().getColumn() + SEPARATOR + node.getEndMark().getColumn();
        includeNode.setTag(new Tag(INCLUDE_APPLIED_TAG + resourceName + SEPARATOR + markInfo));
        return includeNode;
    }

    @Override
    public void beforeProcessingResolvedNode(Tag tag, Node originalValueNode, Node resolvedNode) {
        if (INCLUDE_TAG.equals((Object)tag)) {
            if (originalValueNode.getNodeId() != NodeId.scalar) {
                return;
            }
            this.contextPath.push((ScalarNode)originalValueNode);
        } else if (tag.startsWith(INCLUDE_APPLIED_TAG)) {
            this.contextPath.push(tag);
        }
    }

    @Override
    public void afterProcessingResolvedNode(Tag tag, Node originalValueNode, Node resolvedNode) {
        this.contextPath.pop();
    }

    private Node mockInclude(Node node) {
        return new ScalarNode(Tag.STR, "invalid", node.getStartMark(), node.getEndMark(), null);
    }

    @Override
    public void setContextPath(ContextPath contextPath) {
        this.contextPath = contextPath;
    }

    @Override
    public ContextPath getContextPath() {
        return this.contextPath;
    }

    public static class IncludeScalarNode
    extends ScalarNode {
        private String includeName;

        public IncludeScalarNode(String includeName, String value, ScalarNode node) {
            super(Tag.STR, value, node.getStartMark(), node.getEndMark(), node.getStyle());
            this.includeName = includeName;
        }

        public String getIncludeName() {
            return this.includeName;
        }
    }
}

