/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.builder;

import org.raml.parser.builder.PojoTupleBuilder;
import org.raml.parser.builder.ScalarTupleBuilder;
import org.raml.parser.tagresolver.IncludeResolver;
import org.raml.parser.utils.NodeUtils;
import org.raml.parser.utils.ReflectionUtils;
import org.raml.parser.visitor.SchemaCompiler;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class SchemaTupleBuilder
extends ScalarTupleBuilder {
    private static final String SCHEMA_FIELD_NAME = "schema";
    private static final String PARSED_SCHEMA_FIELD_NAME = "compiledSchema";

    public SchemaTupleBuilder() {
        super(SCHEMA_FIELD_NAME, String.class);
    }

    @Override
    public Object buildValue(Object parent, ScalarNode node) {
        Object result = super.buildValue(parent, node);
        Object schema = this.compileSchema(node);
        ReflectionUtils.setProperty(parent, PARSED_SCHEMA_FIELD_NAME, schema);
        return result;
    }

    private Object compileSchema(ScalarNode node) {
        String mimeType;
        String value = node.getValue();
        if (value == null || NodeUtils.isNonStringTag(node.getTag())) {
            return null;
        }
        Object schema = null;
        String string = mimeType = this.getParent() instanceof PojoTupleBuilder ? ((PojoTupleBuilder)this.getParent()).getFieldName() : null;
        if (mimeType != null && mimeType.contains("xml")) {
            schema = SchemaCompiler.getInstance().compile(value);
        } else if (mimeType != null && mimeType.contains("json") && node instanceof IncludeResolver.IncludeScalarNode) {
            schema = ((IncludeResolver.IncludeScalarNode)node).getIncludeName();
        }
        return schema;
    }
}

