/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.rule;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.SchemaVersion;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.processors.syntax.SyntaxValidator;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.raml.parser.ResolveResourceException;
import org.raml.parser.XsdResourceResolver;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.loader.ResourceLoaderAware;
import org.raml.parser.rule.GlobalSchemasRule;
import org.raml.parser.rule.SimpleRule;
import org.raml.parser.rule.TupleRule;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.ContextPath;
import org.raml.parser.tagresolver.ContextPathAware;
import org.raml.parser.tagresolver.IncludeResolver;
import org.raml.parser.utils.NodeUtils;
import org.raml.parser.visitor.IncludeInfo;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class SchemaRule
extends SimpleRule
implements ContextPathAware,
ResourceLoaderAware {
    private static final SyntaxValidator VALIDATOR = new SyntaxValidator(ValidationConfiguration.newBuilder().setDefaultVersion(SchemaVersion.DRAFTV3).freeze());
    private ContextPath contextPath;
    private ResourceLoader resourceLoader;

    public SchemaRule() {
        super("schema", String.class);
    }

    @Override
    public List<ValidationResult> doValidateValue(ScalarNode node) {
        String value = node.getValue();
        List<ValidationResult> validationResults = super.doValidateValue(node);
        IncludeInfo globaSchemaIncludeInfo = null;
        ContextPath actualContextPath = this.contextPath;
        ScalarNode schemaNode = this.getGlobalSchemaNode(value);
        if (schemaNode == null) {
            schemaNode = node;
        } else {
            value = schemaNode.getValue();
            if (schemaNode.getTag().startsWith("!include-applied_")) {
                globaSchemaIncludeInfo = new IncludeInfo(schemaNode.getTag());
                actualContextPath = new ContextPath(globaSchemaIncludeInfo);
            }
        }
        if (value == null || NodeUtils.isNonStringTag(schemaNode.getTag())) {
            return validationResults;
        }
        String mimeType = ((ScalarNode)this.getParentTupleRule().getKey()).getValue();
        if (mimeType.contains("json")) {
            try {
                JsonNode jsonNode = JsonLoader.fromString((String)value);
                ProcessingReport report = VALIDATOR.validateSchema(jsonNode);
                if (!report.isSuccess()) {
                    StringBuilder msg = new StringBuilder("invalid JSON schema");
                    msg.append(this.getSourceErrorDetail(node));
                    for (ProcessingMessage processingMessage : report) {
                        msg.append("\n").append(processingMessage.toString());
                    }
                    validationResults.add(this.getErrorResult(msg.toString(), this.getLineOffset(schemaNode), globaSchemaIncludeInfo));
                }
            }
            catch (JsonParseException jpe) {
                String msg = "invalid JSON schema" + this.getSourceErrorDetail(node) + jpe.getOriginalMessage();
                JsonLocation loc = jpe.getLocation();
                validationResults.add(this.getErrorResult(msg, this.getLineOffset(schemaNode) + loc.getLineNr(), globaSchemaIncludeInfo));
            }
            catch (IOException e) {
                String prefix = "invalid JSON schema" + this.getSourceErrorDetail(node);
                validationResults.add(this.getErrorResult(prefix + e.getMessage(), -1, globaSchemaIncludeInfo));
            }
        } else if (mimeType.contains("xml")) {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            factory.setResourceResolver(new XsdResourceResolver(actualContextPath, this.resourceLoader));
            try {
                factory.newSchema(new StreamSource(new StringReader(value)));
            }
            catch (SAXParseException e) {
                String msg = "invalid XML schema" + this.getSourceErrorDetail(node) + e.getMessage();
                validationResults.add(this.getErrorResult(msg, this.getLineOffset(schemaNode) + e.getLineNumber(), globaSchemaIncludeInfo));
            }
            catch (SAXException e) {
                String msg = "invalid XML schema" + this.getSourceErrorDetail(node);
                validationResults.add(this.getErrorResult(msg, this.getLineOffset(schemaNode), globaSchemaIncludeInfo));
            }
            catch (ResolveResourceException e) {
                String msg = "invalid XML schema: " + e.getMessage();
                validationResults.add(this.getErrorResult(msg, this.getLineOffset(schemaNode), globaSchemaIncludeInfo));
            }
        }
        return validationResults;
    }

    private ValidationResult getErrorResult(String msg, int line, IncludeInfo globaSchemaIncludeInfo) {
        ValidationResult errorResult = ValidationResult.createErrorResult(msg, line, -1, -1);
        if (globaSchemaIncludeInfo != null) {
            errorResult.setExtraIncludeInfo(globaSchemaIncludeInfo);
        }
        return errorResult;
    }

    private int getLineOffset(ScalarNode schemaNode) {
        boolean isInclude = schemaNode.getTag().startsWith("!include-applied_");
        return isInclude ? -1 : schemaNode.getStartMark().getLine();
    }

    private String getSourceErrorDetail(ScalarNode node) {
        String msg = "";
        if (node instanceof IncludeResolver.IncludeScalarNode) {
            msg = " (" + ((IncludeResolver.IncludeScalarNode)node).getIncludeName() + ")";
        } else if (node.getValue().matches("\\w.*")) {
            msg = " (" + node.getValue() + ")";
        }
        return msg + ": ";
    }

    private ScalarNode getGlobalSchemaNode(String key) {
        GlobalSchemasRule schemasRule = (GlobalSchemasRule)this.getRootTupleRule().getRuleByFieldName("schemas");
        return schemasRule.getSchema(key);
    }

    @Override
    public TupleRule<?, ?> deepCopy() {
        this.checkClassToCopy(SchemaRule.class);
        SchemaRule copy = new SchemaRule();
        copy.setNodeRuleFactory(this.getNodeRuleFactory());
        copy.setHandler(this.getHandler());
        copy.setContextPath(this.contextPath);
        copy.setResourceLoader(this.resourceLoader);
        return copy;
    }

    @Override
    public void setContextPath(ContextPath contextPath) {
        this.contextPath = contextPath;
    }

    @Override
    public ContextPath getContextPath() {
        return this.contextPath;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

