/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.nodes;

import javax.annotation.Nonnull;
import org.raml.yagi.framework.nodes.KeyValueNodeImpl;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.StringNode;

public class ResourceNode
extends KeyValueNodeImpl {
    public ResourceNode() {
    }

    public ResourceNode(ResourceNode node) {
        super((KeyValueNodeImpl)node);
    }

    public String getRelativeUri() {
        Node key = this.getKey();
        if (key instanceof StringNode) {
            return ((StringNode)key).getValue();
        }
        throw new IllegalStateException("Key must be a string but was a " + key.getClass());
    }

    public String getResourcePath() {
        String path = this.getRelativeUri();
        ResourceNode parent = this.getParentResourceNode();
        if (parent != null) {
            path = parent.getResourcePath() + path;
        }
        return path;
    }

    public ResourceNode getParentResourceNode() {
        Node parent = this.getParent();
        if (parent != null && parent.getParent() instanceof ResourceNode) {
            return (ResourceNode)parent.getParent();
        }
        return null;
    }

    public String getResourcePathName() {
        String fullPath = this.getRelativeUri().substring(1);
        String[] path = fullPath.split("/");
        for (int i = path.length - 1; i >= 0; --i) {
            if (path[i].contains("{")) continue;
            return path[i];
        }
        ResourceNode parent = this.getParentResourceNode();
        if (parent == null) {
            return "";
        }
        return parent.getResourcePathName();
    }

    @Nonnull
    public Node copy() {
        return new ResourceNode(this);
    }
}

