/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.phase;

import java.util.List;
import org.raml.v2.internal.impl.commons.nodes.RamlDocumentNode;
import org.raml.v2.internal.impl.commons.nodes.ResourceNode;
import org.raml.v2.internal.utils.ResourcePathUtils;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeAnnotation;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.nodes.WarningMessageAnnotation;
import org.raml.yagi.framework.phase.Transformer;
import org.raml.yagi.framework.util.NodeSelector;

public class UnusedParametersTransformer
implements Transformer {
    public boolean matches(Node node) {
        return node instanceof RamlDocumentNode || node instanceof ResourceNode;
    }

    public Node transform(Node node) {
        if (node instanceof RamlDocumentNode) {
            Node baseUriNode = NodeSelector.selectFrom((String)"baseUri", (Node)node);
            if (baseUriNode != null) {
                String value = NodeSelector.selectStringValue((String)"value", (Node)baseUriNode);
                List<String> templates = ResourcePathUtils.getUriTemplates(value);
                this.checkUriParameters("baseUriParameters", node, templates);
            }
        } else if (node instanceof ResourceNode) {
            List<String> templates = ResourcePathUtils.getUriTemplates(((ResourceNode)node).getRelativeUri());
            this.checkUriParameters("uriParameters", ((ResourceNode)node).getValue(), templates);
        }
        return node;
    }

    private void checkUriParameters(String key, Node node, List<String> templates) {
        Node parametersNode = NodeSelector.selectFrom((String)key, (Node)node);
        if (parametersNode != null) {
            for (Node child : parametersNode.getChildren()) {
                String parameterName = ((SimpleTypeNode)((KeyValueNode)child).getKey()).getLiteralValue();
                if (templates.contains(parameterName)) continue;
                child.annotate((NodeAnnotation)new WarningMessageAnnotation("Unused uri parameter '" + parameterName + "'"));
            }
        }
    }
}

