/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.loader.CompositeResourceLoader;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.FileResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.model.common.ValidationResult;
import org.raml.v2.api.model.v08.parameters.Parameter;
import org.raml.v2.api.model.v08.system.types.StringType;
import org.raml.v2.api.model.v08.system.types.ValueType;
import org.raml.v2.api.model.v10.RamlFragment;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.api.DocumentationItem;
import org.raml.v2.api.model.v10.api.Library;
import org.raml.v2.api.model.v10.datamodel.ExampleSpec;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.methods.Trait;
import org.raml.v2.api.model.v10.resources.ResourceType;
import org.raml.v2.api.model.v10.security.SecurityScheme;
import org.raml.v2.internal.impl.RamlBuilder;
import org.raml.v2.internal.impl.commons.RamlHeader;
import org.raml.v2.internal.impl.commons.RamlVersion;
import org.raml.v2.internal.impl.commons.model.DefaultModelElement;
import org.raml.v2.internal.impl.commons.model.RamlValidationResult;
import org.raml.v2.internal.impl.commons.model.factory.TypeDeclarationModelFactory;
import org.raml.v2.internal.impl.commons.nodes.RamlDocumentNode;
import org.raml.v2.internal.utils.RamlNodeUtils;
import org.raml.v2.internal.utils.StreamUtils;
import org.raml.yagi.framework.model.DefaultModelBindingConfiguration;
import org.raml.yagi.framework.model.ModelBindingConfiguration;
import org.raml.yagi.framework.model.ModelProxyBuilder;
import org.raml.yagi.framework.model.NodeModel;
import org.raml.yagi.framework.model.NodeModelFactory;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.KeyValueNodeImpl;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.StringNodeImpl;

public class RamlModelBuilder {
    public static final String MODEL_PACKAGE = "org.raml.v2.internal.impl.commons.model";
    private ResourceLoader resourceLoader;
    private RamlBuilder builder = new RamlBuilder();

    public RamlModelBuilder() {
        this((ResourceLoader)new DefaultResourceLoader());
    }

    public RamlModelBuilder(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Nonnull
    public RamlModelResult buildApi(String ramlLocation) {
        String content = this.getRamlContent(ramlLocation);
        if (content == null) {
            return this.generateRamlApiResult("Raml does not exist at: " + ramlLocation);
        }
        return this.buildApi(content, ramlLocation);
    }

    @Nonnull
    public RamlModelResult buildApi(File ramlFile) {
        String content = this.getRamlContent(ramlFile);
        if (content == null) {
            return this.generateRamlApiResult("Files does not exist or is not a regular file: " + ramlFile.getPath());
        }
        return this.buildApi(content, ramlFile.getPath());
    }

    @Nonnull
    public RamlModelResult buildApi(Reader reader, String ramlLocation) {
        String content = this.getRamlContent(reader);
        if (content == null) {
            return this.generateRamlApiResult("Invalid reader provided with location: " + ramlLocation);
        }
        return this.buildApi(content, ramlLocation);
    }

    @Nonnull
    public RamlModelResult buildApi(String content, String ramlLocation) {
        if (content == null) {
            return this.buildApi(ramlLocation);
        }
        Node ramlNode = this.builder.build(content, this.resourceLoader, ramlLocation);
        return this.generateRamlApiResult(ramlNode, this.getFragment(content));
    }

    private RamlFragment getFragment(String content) {
        try {
            RamlHeader ramlHeader = RamlHeader.parse(content);
            return ramlHeader.getFragment();
        }
        catch (RamlHeader.InvalidHeaderException invalidHeaderException) {
            return null;
        }
    }

    private RamlModelResult generateRamlApiResult(Node ramlNode, RamlFragment fragment) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        List<ErrorNode> errors = RamlNodeUtils.getErrors(ramlNode);
        for (ErrorNode errorNode : errors) {
            validationResults.add(new RamlValidationResult(errorNode));
        }
        if (validationResults.isEmpty()) {
            return this.wrapTree(ramlNode, fragment);
        }
        return new RamlModelResult(validationResults);
    }

    private RamlModelResult generateRamlApiResult(String errorMessage) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        validationResults.add(new RamlValidationResult(errorMessage));
        return new RamlModelResult(validationResults);
    }

    private RamlModelResult wrapTree(Node ramlNode, RamlFragment fragment) {
        if (ramlNode instanceof RamlDocumentNode && RamlNodeUtils.getVersion(ramlNode) == RamlVersion.RAML_08) {
            org.raml.v2.api.model.v08.api.Api apiV08 = (org.raml.v2.api.model.v08.api.Api)ModelProxyBuilder.createModel(org.raml.v2.api.model.v08.api.Api.class, (NodeModel)new org.raml.v2.internal.impl.commons.model.Api((RamlDocumentNode)ramlNode), (ModelBindingConfiguration)this.createV08Binding());
            return new RamlModelResult(apiV08);
        }
        if (ramlNode instanceof RamlDocumentNode) {
            Api apiV10 = (Api)ModelProxyBuilder.createModel(Api.class, (NodeModel)new org.raml.v2.internal.impl.commons.model.Api((RamlDocumentNode)ramlNode), (ModelBindingConfiguration)this.createV10Binding());
            return new RamlModelResult(apiV10);
        }
        if (fragment == RamlFragment.Library) {
            Library library = (Library)ModelProxyBuilder.createModel(Library.class, (NodeModel)new DefaultModelElement(ramlNode), (ModelBindingConfiguration)this.createV10Binding());
            return new RamlModelResult(library);
        }
        if (fragment == RamlFragment.DataType || fragment == RamlFragment.AnnotationTypeDeclaration) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)ModelProxyBuilder.createModel(TypeDeclaration.class, (NodeModel)new TypeDeclarationModelFactory().create(ramlNode), (ModelBindingConfiguration)this.createV10Binding());
            return new RamlModelResult(typeDeclaration);
        }
        if (fragment == RamlFragment.DocumentationItem) {
            DocumentationItem documentationItem = (DocumentationItem)ModelProxyBuilder.createModel(DocumentationItem.class, (NodeModel)new DefaultModelElement(ramlNode), (ModelBindingConfiguration)this.createV10Binding());
            return new RamlModelResult(documentationItem);
        }
        if (fragment == RamlFragment.SecurityScheme) {
            SecurityScheme securityScheme = (SecurityScheme)ModelProxyBuilder.createModel(SecurityScheme.class, (NodeModel)new DefaultModelElement(ramlNode), (ModelBindingConfiguration)this.createV10Binding());
            return new RamlModelResult(securityScheme);
        }
        if (fragment == RamlFragment.Trait) {
            Trait trait = (Trait)ModelProxyBuilder.createModel(Trait.class, (NodeModel)new DefaultModelElement(ramlNode), (ModelBindingConfiguration)this.createV10Binding());
            return new RamlModelResult(trait);
        }
        if (fragment == RamlFragment.ResourceType) {
            ResourceType resourceType = (ResourceType)ModelProxyBuilder.createModel(ResourceType.class, (NodeModel)new DefaultModelElement(ramlNode), (ModelBindingConfiguration)this.createV10Binding());
            return new RamlModelResult(resourceType);
        }
        if (fragment == RamlFragment.NamedExample) {
            if (!(ramlNode instanceof KeyValueNode)) {
                ramlNode = new KeyValueNodeImpl((Node)new StringNodeImpl("__NamedExample_Fragment__"), ramlNode);
            }
            ExampleSpec exampleSpec = (ExampleSpec)ModelProxyBuilder.createModel(ExampleSpec.class, (NodeModel)new org.raml.v2.internal.impl.commons.model.ExampleSpec((KeyValueNode)ramlNode), (ModelBindingConfiguration)this.createV10Binding());
            return new RamlModelResult(exampleSpec);
        }
        throw new IllegalStateException("Invalid ramlNode type (" + ramlNode.getClass().getSimpleName() + ") or fragment (" + (Object)((Object)fragment) + ") combination");
    }

    private ModelBindingConfiguration createV10Binding() {
        DefaultModelBindingConfiguration bindingConfiguration = new DefaultModelBindingConfiguration();
        bindingConfiguration.bindPackage(MODEL_PACKAGE);
        bindingConfiguration.bind(org.raml.v2.api.model.v10.system.types.StringType.class, org.raml.v2.internal.impl.commons.model.StringType.class);
        bindingConfiguration.bind(org.raml.v2.api.model.v10.system.types.ValueType.class, org.raml.v2.internal.impl.commons.model.StringType.class);
        bindingConfiguration.defaultTo(DefaultModelElement.class);
        bindingConfiguration.bind(TypeDeclaration.class, (NodeModelFactory)new TypeDeclarationModelFactory());
        bindingConfiguration.reverseBindPackage("org.raml.v2.api.model.v10.datamodel");
        return bindingConfiguration;
    }

    private ModelBindingConfiguration createV08Binding() {
        DefaultModelBindingConfiguration bindingConfiguration = new DefaultModelBindingConfiguration();
        bindingConfiguration.bindPackage(MODEL_PACKAGE);
        bindingConfiguration.bind(StringType.class, org.raml.v2.internal.impl.commons.model.StringType.class);
        bindingConfiguration.bind(ValueType.class, org.raml.v2.internal.impl.commons.model.StringType.class);
        bindingConfiguration.bind(Parameter.class, (NodeModelFactory)new TypeDeclarationModelFactory());
        bindingConfiguration.reverseBindPackage("org.raml.v2.api.model.v08.parameters");
        bindingConfiguration.defaultTo(DefaultModelElement.class);
        return bindingConfiguration;
    }

    private String getRamlContent(File ramlFile) {
        if (ramlFile == null || !ramlFile.isFile()) {
            return null;
        }
        CompositeResourceLoader fileLoader = new CompositeResourceLoader(new ResourceLoader[]{this.resourceLoader, new FileResourceLoader(ramlFile.getParent())});
        return this.getRamlContent(ramlFile.getName(), (ResourceLoader)fileLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRamlContent(Reader ramlReader) {
        if (ramlReader == null) {
            return null;
        }
        try {
            String string = IOUtils.toString((Reader)ramlReader);
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly((Reader)ramlReader);
        }
    }

    private String getRamlContent(String ramlLocation) {
        return this.getRamlContent(ramlLocation, this.resourceLoader);
    }

    private String getRamlContent(String ramlLocation, ResourceLoader loader) {
        if (ramlLocation == null) {
            return null;
        }
        InputStream ramlStream = loader.fetchResource(ramlLocation);
        if (ramlStream != null) {
            return StreamUtils.toString(ramlStream);
        }
        return null;
    }
}

