/*
 * Decompiled with CFR 0.152.
 */
package org.r10r.sqlify.core;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.r10r.sqlify.SqlifyException;

public final class SqlifyCore {
    protected static final Pattern USER_PARAMETER_EXTRACTION_PATTERN = Pattern.compile("\\{(.*?)\\}");

    protected static final String convertNamedParametersIntoJdbcCompliantPreparedStatement(String sqlWithNamedPlaceholers) {
        return sqlWithNamedPlaceholers.replaceAll("\\{.*?\\}", "?");
    }

    protected static final List<String> extractParameterNames(String userSpecifiedSql) {
        ArrayList<String> allParametersSorted = new ArrayList<String>();
        Matcher matcher = USER_PARAMETER_EXTRACTION_PATTERN.matcher(userSpecifiedSql);
        while (matcher.find()) {
            String name = matcher.group(1);
            allParametersSorted.add(name);
        }
        return allParametersSorted;
    }

    protected static final PreparedStatement applyParameterMapToPreparedStatement(PreparedStatement preparedStatement, Map<String, Object> parameterMap, List<String> parametersInSqlSorted) {
        try {
            for (int i = 0; i < parametersInSqlSorted.size(); ++i) {
                Object value = parameterMap.get(parametersInSqlSorted.get(i));
                int positionInPreparedStatement = i + 1;
                if (value instanceof BigDecimal) {
                    preparedStatement.setBigDecimal(positionInPreparedStatement, (BigDecimal)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    preparedStatement.setBoolean(positionInPreparedStatement, (Boolean)value);
                    continue;
                }
                if (value instanceof Date) {
                    preparedStatement.setDate(positionInPreparedStatement, (Date)value);
                    continue;
                }
                if (value instanceof Double) {
                    preparedStatement.setDouble(positionInPreparedStatement, (Double)value);
                    continue;
                }
                if (value instanceof Float) {
                    preparedStatement.setFloat(positionInPreparedStatement, ((Float)value).floatValue());
                    continue;
                }
                if (value instanceof Integer) {
                    preparedStatement.setInt(positionInPreparedStatement, (Integer)value);
                    continue;
                }
                if (value instanceof Long) {
                    preparedStatement.setLong(positionInPreparedStatement, (Long)value);
                    continue;
                }
                if (value instanceof Short) {
                    preparedStatement.setShort(positionInPreparedStatement, (Short)value);
                    continue;
                }
                if (value instanceof String) {
                    preparedStatement.setString(positionInPreparedStatement, (String)value);
                    continue;
                }
                if (value instanceof Time) {
                    preparedStatement.setTime(positionInPreparedStatement, (Time)value);
                    continue;
                }
                if (value instanceof Timestamp) {
                    preparedStatement.setTimestamp(positionInPreparedStatement, (Timestamp)value);
                    continue;
                }
                if (value instanceof URL) {
                    preparedStatement.setURL(positionInPreparedStatement, (URL)value);
                    continue;
                }
                preparedStatement.setObject(positionInPreparedStatement, value);
            }
        }
        catch (SQLException sqlException) {
            throw new SqlifyException("Ops. An error occurred. " + sqlException.getMessage(), sqlException);
        }
        return preparedStatement;
    }
}

