/*
 * Decompiled with CFR 0.152.
 */
package org.r10r.sqlify.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.r10r.sqlify.SqlifyException;
import org.r10r.sqlify.core.Batch;
import org.r10r.sqlify.core.SqlifyCore;

public final class SqlifyBatched {
    private final String sqlForJdbc;
    private final List<Batch> parameterMapBatches;
    private final List<String> parametersInSqlSorted;

    public SqlifyBatched(String userProvidedSqlWithPlaceholder, List<Batch> parameterMapBatches) {
        if (parameterMapBatches.isEmpty()) {
            throw new IllegalArgumentException("You have to provide at least one batch when using batched sql mode...");
        }
        this.parameterMapBatches = parameterMapBatches;
        this.parametersInSqlSorted = SqlifyCore.extractParameterNames(userProvidedSqlWithPlaceholder);
        this.sqlForJdbc = SqlifyCore.convertNamedParametersIntoJdbcCompliantPreparedStatement(userProvidedSqlWithPlaceholder);
    }

    public int[] executeUpdateBatch(Connection connection) {
        int[] nArray;
        block9: {
            PreparedStatement preparedStatement = connection.prepareStatement(this.sqlForJdbc);
            try {
                int[] numberOfChangedLines;
                for (Batch batch : this.parameterMapBatches) {
                    SqlifyCore.applyParameterMapToPreparedStatement(preparedStatement, batch.getParameterMap(), this.parametersInSqlSorted);
                    preparedStatement.addBatch();
                }
                nArray = numberOfChangedLines = preparedStatement.executeBatch();
                if (preparedStatement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sqlException) {
                    throw new SqlifyException("Ops. Something strange happened " + sqlException, sqlException);
                }
            }
            preparedStatement.close();
        }
        return nArray;
    }
}

