/*
 * Decompiled with CFR 0.152.
 */
package quickfix.examples.banzai;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;
import quickfix.Application;
import quickfix.BooleanField;
import quickfix.CharField;
import quickfix.DefaultMessageFactory;
import quickfix.DoNotSend;
import quickfix.DoubleField;
import quickfix.FieldNotFound;
import quickfix.IncorrectDataFormat;
import quickfix.IncorrectTagValue;
import quickfix.Message;
import quickfix.RejectLogon;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.SessionNotFound;
import quickfix.StringField;
import quickfix.UnsupportedMessageType;
import quickfix.examples.banzai.Execution;
import quickfix.examples.banzai.ExecutionTableModel;
import quickfix.examples.banzai.LogonEvent;
import quickfix.examples.banzai.Order;
import quickfix.examples.banzai.OrderSide;
import quickfix.examples.banzai.OrderTIF;
import quickfix.examples.banzai.OrderTableModel;
import quickfix.examples.banzai.OrderType;
import quickfix.examples.banzai.TwoWayMap;
import quickfix.field.ClOrdID;
import quickfix.field.CxlType;
import quickfix.field.ExecID;
import quickfix.field.HandlInst;
import quickfix.field.LastShares;
import quickfix.field.LeavesQty;
import quickfix.field.LocateReqd;
import quickfix.field.MsgType;
import quickfix.field.OrdStatus;
import quickfix.field.OrdType;
import quickfix.field.OrderQty;
import quickfix.field.OrigClOrdID;
import quickfix.field.Price;
import quickfix.field.Side;
import quickfix.field.StopPx;
import quickfix.field.Symbol;
import quickfix.field.Text;
import quickfix.field.TimeInForce;
import quickfix.field.TransactTime;
import quickfix.fix41.OrderCancelReplaceRequest;
import quickfix.fix41.OrderCancelRequest;
import quickfix.fix44.NewOrderSingle;

public class BanzaiApplication
implements Application {
    private final DefaultMessageFactory messageFactory = new DefaultMessageFactory();
    private OrderTableModel orderTableModel = null;
    private ExecutionTableModel executionTableModel = null;
    private final ObservableOrder observableOrder = new ObservableOrder();
    private final ObservableLogon observableLogon = new ObservableLogon();
    private boolean isAvailable = true;
    private boolean isMissingField;
    private static final TwoWayMap sideMap = new TwoWayMap();
    private static final TwoWayMap typeMap = new TwoWayMap();
    private static final TwoWayMap tifMap = new TwoWayMap();
    private static final HashMap<SessionID, HashSet<ExecID>> execIDs = new HashMap();

    public BanzaiApplication(OrderTableModel orderTableModel, ExecutionTableModel executionTableModel) {
        this.orderTableModel = orderTableModel;
        this.executionTableModel = executionTableModel;
    }

    public void onCreate(SessionID sessionID) {
    }

    public void onLogon(SessionID sessionID) {
        this.observableLogon.logon(sessionID);
    }

    public void onLogout(SessionID sessionID) {
        this.observableLogon.logoff(sessionID);
    }

    public void toAdmin(Message message, SessionID sessionID) {
    }

    public void toApp(Message message, SessionID sessionID) throws DoNotSend {
    }

    public void fromAdmin(Message message, SessionID sessionID) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, RejectLogon {
    }

    public void fromApp(Message message, SessionID sessionID) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
        try {
            SwingUtilities.invokeLater(new MessageProcessor(message, sessionID));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendSessionReject(Message message, int rejectReason) throws FieldNotFound, SessionNotFound {
        Message reply = this.createMessage(message, "3");
        this.reverseRoute(message, reply);
        String refSeqNum = message.getHeader().getString(34);
        reply.setString(45, refSeqNum);
        reply.setString(372, message.getHeader().getString(35));
        reply.setInt(373, rejectReason);
        Session.sendToTarget((Message)reply);
    }

    private void sendBusinessReject(Message message, int rejectReason, String rejectText) throws FieldNotFound, SessionNotFound {
        Message reply = this.createMessage(message, "j");
        this.reverseRoute(message, reply);
        String refSeqNum = message.getHeader().getString(34);
        reply.setString(45, refSeqNum);
        reply.setString(372, message.getHeader().getString(35));
        reply.setInt(380, rejectReason);
        reply.setString(58, rejectText);
        Session.sendToTarget((Message)reply);
    }

    private Message createMessage(Message message, String msgType) throws FieldNotFound {
        return this.messageFactory.create(message.getHeader().getString(8), msgType);
    }

    private void reverseRoute(Message message, Message reply) throws FieldNotFound {
        reply.getHeader().setString(49, message.getHeader().getString(56));
        reply.getHeader().setString(56, message.getHeader().getString(49));
    }

    private void executionReport(Message message, SessionID sessionID) throws FieldNotFound {
        OrdStatus ordStatus;
        BigDecimal fillSize;
        ExecID execID = (ExecID)message.getField((StringField)new ExecID());
        if (this.alreadyProcessed(execID, sessionID)) {
            return;
        }
        Order order = this.orderTableModel.getOrder(message.getField((StringField)new ClOrdID()).getValue());
        if (order == null) {
            return;
        }
        if (message.isSetField(32)) {
            LastShares lastShares = new LastShares();
            message.getField((DoubleField)lastShares);
            fillSize = new BigDecimal("" + lastShares.getValue());
        } else {
            LeavesQty leavesQty = new LeavesQty();
            message.getField((DoubleField)leavesQty);
            fillSize = new BigDecimal(order.getQuantity()).subtract(new BigDecimal("" + leavesQty.getValue()));
        }
        if (fillSize.compareTo(BigDecimal.ZERO) > 0) {
            order.setOpen(order.getOpen() - (int)Double.parseDouble(fillSize.toPlainString()));
            order.setExecuted(Double.parseDouble(message.getString(14)));
            order.setAvgPx(Double.parseDouble(message.getString(6)));
        }
        if ((ordStatus = (OrdStatus)message.getField((CharField)new OrdStatus())).valueEquals('8')) {
            order.setRejected(true);
            order.setOpen(0);
        } else if (ordStatus.valueEquals('4') || ordStatus.valueEquals('3')) {
            order.setCanceled(true);
            order.setOpen(0);
        } else if (ordStatus.valueEquals('0') && order.isNew()) {
            order.setNew(false);
        }
        try {
            order.setMessage(message.getField((StringField)new Text()).getValue());
        }
        catch (FieldNotFound fieldNotFound) {
            // empty catch block
        }
        this.orderTableModel.updateOrder(order, message.getField((StringField)new ClOrdID()).getValue());
        this.observableOrder.update(order);
        if (fillSize.compareTo(BigDecimal.ZERO) > 0) {
            Execution execution = new Execution();
            execution.setExchangeID(sessionID + message.getField((StringField)new ExecID()).getValue());
            execution.setSymbol(message.getField((StringField)new Symbol()).getValue());
            execution.setQuantity(fillSize.intValue());
            if (message.isSetField(31)) {
                execution.setPrice(Double.parseDouble(message.getString(31)));
            }
            Side side = (Side)message.getField((CharField)new Side());
            execution.setSide(this.FIXSideToSide(side));
            this.executionTableModel.addExecution(execution);
        }
    }

    private void cancelReject(Message message, SessionID sessionID) throws FieldNotFound {
        String id = message.getField((StringField)new ClOrdID()).getValue();
        Order order = this.orderTableModel.getOrder(id);
        if (order == null) {
            return;
        }
        if (order.getOriginalID() != null) {
            order = this.orderTableModel.getOrder(order.getOriginalID());
        }
        try {
            order.setMessage(message.getField((StringField)new Text()).getValue());
        }
        catch (FieldNotFound fieldNotFound) {
            // empty catch block
        }
        this.orderTableModel.updateOrder(order, message.getField((StringField)new OrigClOrdID()).getValue());
    }

    private boolean alreadyProcessed(ExecID execID, SessionID sessionID) {
        HashSet<Object> set = execIDs.get(sessionID);
        if (set == null) {
            set = new HashSet();
            set.add(execID);
            execIDs.put(sessionID, set);
            return false;
        }
        if (set.contains(execID)) {
            return true;
        }
        set.add(execID);
        return false;
    }

    private void send(Message message, SessionID sessionID) {
        try {
            Session.sendToTarget((Message)message, (SessionID)sessionID);
        }
        catch (SessionNotFound e) {
            System.out.println((Object)e);
        }
    }

    public void send(Order order) {
        String beginString;
        switch (beginString = order.getSessionID().getBeginString()) {
            case "FIX.4.0": {
                this.send40(order);
                break;
            }
            case "FIX.4.1": {
                this.send41(order);
                break;
            }
            case "FIX.4.2": {
                this.send42(order);
                break;
            }
            case "FIX.4.3": {
                this.send43(order);
                break;
            }
            case "FIX.4.4": {
                this.send44(order);
                break;
            }
            case "FIXT.1.1": {
                this.send50(order);
            }
        }
    }

    public void send40(Order order) {
        quickfix.fix40.NewOrderSingle newOrderSingle = new quickfix.fix40.NewOrderSingle(new ClOrdID(order.getID()), new HandlInst('1'), new Symbol(order.getSymbol()), this.sideToFIXSide(order.getSide()), new OrderQty((double)order.getQuantity()), this.typeToFIXType(order.getType()));
        this.send(this.populateOrder(order, (Message)newOrderSingle), order.getSessionID());
    }

    public void send41(Order order) {
        quickfix.fix41.NewOrderSingle newOrderSingle = new quickfix.fix41.NewOrderSingle(new ClOrdID(order.getID()), new HandlInst('1'), new Symbol(order.getSymbol()), this.sideToFIXSide(order.getSide()), this.typeToFIXType(order.getType()));
        newOrderSingle.set(new OrderQty((double)order.getQuantity()));
        this.send(this.populateOrder(order, (Message)newOrderSingle), order.getSessionID());
    }

    public void send42(Order order) {
        quickfix.fix42.NewOrderSingle newOrderSingle = new quickfix.fix42.NewOrderSingle(new ClOrdID(order.getID()), new HandlInst('1'), new Symbol(order.getSymbol()), this.sideToFIXSide(order.getSide()), new TransactTime(), this.typeToFIXType(order.getType()));
        newOrderSingle.set(new OrderQty((double)order.getQuantity()));
        this.send(this.populateOrder(order, (Message)newOrderSingle), order.getSessionID());
    }

    public void send43(Order order) {
        quickfix.fix43.NewOrderSingle newOrderSingle = new quickfix.fix43.NewOrderSingle(new ClOrdID(order.getID()), new HandlInst('1'), this.sideToFIXSide(order.getSide()), new TransactTime(), this.typeToFIXType(order.getType()));
        newOrderSingle.set(new OrderQty((double)order.getQuantity()));
        newOrderSingle.set(new Symbol(order.getSymbol()));
        this.send(this.populateOrder(order, (Message)newOrderSingle), order.getSessionID());
    }

    public void send44(Order order) {
        NewOrderSingle newOrderSingle = new NewOrderSingle(new ClOrdID(order.getID()), this.sideToFIXSide(order.getSide()), new TransactTime(), this.typeToFIXType(order.getType()));
        newOrderSingle.set(new OrderQty((double)order.getQuantity()));
        newOrderSingle.set(new Symbol(order.getSymbol()));
        newOrderSingle.set(new HandlInst('1'));
        this.send(this.populateOrder(order, (Message)newOrderSingle), order.getSessionID());
    }

    public void send50(Order order) {
        quickfix.fix50.NewOrderSingle newOrderSingle = new quickfix.fix50.NewOrderSingle(new ClOrdID(order.getID()), this.sideToFIXSide(order.getSide()), new TransactTime(), this.typeToFIXType(order.getType()));
        newOrderSingle.set(new OrderQty((double)order.getQuantity()));
        newOrderSingle.set(new Symbol(order.getSymbol()));
        newOrderSingle.set(new HandlInst('1'));
        this.send(this.populateOrder(order, (Message)newOrderSingle), order.getSessionID());
    }

    public Message populateOrder(Order order, Message newOrderSingle) {
        OrderType type = order.getType();
        if (type == OrderType.LIMIT) {
            newOrderSingle.setField((DoubleField)new Price(order.getLimit().doubleValue()));
        } else if (type == OrderType.STOP) {
            newOrderSingle.setField((DoubleField)new StopPx(order.getStop().doubleValue()));
        } else if (type == OrderType.STOP_LIMIT) {
            newOrderSingle.setField((DoubleField)new Price(order.getLimit().doubleValue()));
            newOrderSingle.setField((DoubleField)new StopPx(order.getStop().doubleValue()));
        }
        if (order.getSide() == OrderSide.SHORT_SELL || order.getSide() == OrderSide.SHORT_SELL_EXEMPT) {
            newOrderSingle.setField((BooleanField)new LocateReqd(false));
        }
        newOrderSingle.setField((CharField)this.tifToFIXTif(order.getTIF()));
        return newOrderSingle;
    }

    public void cancel(Order order) {
        String beginString;
        switch (beginString = order.getSessionID().getBeginString()) {
            case "FIX.4.0": {
                this.cancel40(order);
                break;
            }
            case "FIX.4.1": {
                this.cancel41(order);
                break;
            }
            case "FIX.4.2": {
                this.cancel42(order);
            }
        }
    }

    public void cancel40(Order order) {
        String id = order.generateID();
        quickfix.fix40.OrderCancelRequest message = new quickfix.fix40.OrderCancelRequest(new OrigClOrdID(order.getID()), new ClOrdID(id), new CxlType('F'), new Symbol(order.getSymbol()), this.sideToFIXSide(order.getSide()), new OrderQty((double)order.getQuantity()));
        this.orderTableModel.addID(order, id);
        this.send((Message)message, order.getSessionID());
    }

    public void cancel41(Order order) {
        String id = order.generateID();
        OrderCancelRequest message = new OrderCancelRequest(new OrigClOrdID(order.getID()), new ClOrdID(id), new Symbol(order.getSymbol()), this.sideToFIXSide(order.getSide()));
        message.setField((DoubleField)new OrderQty((double)order.getQuantity()));
        this.orderTableModel.addID(order, id);
        this.send((Message)message, order.getSessionID());
    }

    public void cancel42(Order order) {
        String id = order.generateID();
        quickfix.fix42.OrderCancelRequest message = new quickfix.fix42.OrderCancelRequest(new OrigClOrdID(order.getID()), new ClOrdID(id), new Symbol(order.getSymbol()), this.sideToFIXSide(order.getSide()), new TransactTime());
        message.setField((DoubleField)new OrderQty((double)order.getQuantity()));
        this.orderTableModel.addID(order, id);
        this.send((Message)message, order.getSessionID());
    }

    public void replace(Order order, Order newOrder) {
        String beginString;
        switch (beginString = order.getSessionID().getBeginString()) {
            case "FIX.4.0": {
                this.replace40(order, newOrder);
                break;
            }
            case "FIX.4.1": {
                this.replace41(order, newOrder);
                break;
            }
            case "FIX.4.2": {
                this.replace42(order, newOrder);
            }
        }
    }

    public void replace40(Order order, Order newOrder) {
        quickfix.fix40.OrderCancelReplaceRequest message = new quickfix.fix40.OrderCancelReplaceRequest(new OrigClOrdID(order.getID()), new ClOrdID(newOrder.getID()), new HandlInst('1'), new Symbol(order.getSymbol()), this.sideToFIXSide(order.getSide()), new OrderQty((double)newOrder.getQuantity()), this.typeToFIXType(order.getType()));
        this.orderTableModel.addID(order, newOrder.getID());
        this.send(this.populateCancelReplace(order, newOrder, (Message)message), order.getSessionID());
    }

    public void replace41(Order order, Order newOrder) {
        OrderCancelReplaceRequest message = new OrderCancelReplaceRequest(new OrigClOrdID(order.getID()), new ClOrdID(newOrder.getID()), new HandlInst('1'), new Symbol(order.getSymbol()), this.sideToFIXSide(order.getSide()), this.typeToFIXType(order.getType()));
        this.orderTableModel.addID(order, newOrder.getID());
        this.send(this.populateCancelReplace(order, newOrder, (Message)message), order.getSessionID());
    }

    public void replace42(Order order, Order newOrder) {
        quickfix.fix42.OrderCancelReplaceRequest message = new quickfix.fix42.OrderCancelReplaceRequest(new OrigClOrdID(order.getID()), new ClOrdID(newOrder.getID()), new HandlInst('1'), new Symbol(order.getSymbol()), this.sideToFIXSide(order.getSide()), new TransactTime(), this.typeToFIXType(order.getType()));
        this.orderTableModel.addID(order, newOrder.getID());
        this.send(this.populateCancelReplace(order, newOrder, (Message)message), order.getSessionID());
    }

    Message populateCancelReplace(Order order, Order newOrder, Message message) {
        if (order.getQuantity() != newOrder.getQuantity()) {
            message.setField((DoubleField)new OrderQty((double)newOrder.getQuantity()));
        }
        if (!order.getLimit().equals(newOrder.getLimit())) {
            message.setField((DoubleField)new Price(newOrder.getLimit().doubleValue()));
        }
        return message;
    }

    public Side sideToFIXSide(OrderSide side) {
        return (Side)sideMap.getFirst(side);
    }

    public OrderSide FIXSideToSide(Side side) {
        return (OrderSide)sideMap.getSecond(side);
    }

    public OrdType typeToFIXType(OrderType type) {
        return (OrdType)typeMap.getFirst(type);
    }

    public OrderType FIXTypeToType(OrdType type) {
        return (OrderType)typeMap.getSecond(type);
    }

    public TimeInForce tifToFIXTif(OrderTIF tif) {
        return (TimeInForce)tifMap.getFirst(tif);
    }

    public OrderTIF FIXTifToTif(TimeInForce tif) {
        return (OrderTIF)typeMap.getSecond(tif);
    }

    public void addLogonObserver(Observer observer) {
        this.observableLogon.addObserver(observer);
    }

    public void deleteLogonObserver(Observer observer) {
        this.observableLogon.deleteObserver(observer);
    }

    public void addOrderObserver(Observer observer) {
        this.observableOrder.addObserver(observer);
    }

    public void deleteOrderObserver(Observer observer) {
        this.observableOrder.deleteObserver(observer);
    }

    public boolean isMissingField() {
        return this.isMissingField;
    }

    public void setMissingField(boolean isMissingField) {
        this.isMissingField = isMissingField;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public void setAvailable(boolean isAvailable) {
        this.isAvailable = isAvailable;
    }

    static {
        sideMap.put(OrderSide.BUY, new Side('1'));
        sideMap.put(OrderSide.SELL, new Side('2'));
        sideMap.put(OrderSide.SHORT_SELL, new Side('5'));
        sideMap.put(OrderSide.SHORT_SELL_EXEMPT, new Side('6'));
        sideMap.put(OrderSide.CROSS, new Side('8'));
        sideMap.put(OrderSide.CROSS_SHORT, new Side('9'));
        typeMap.put(OrderType.MARKET, new OrdType('1'));
        typeMap.put(OrderType.LIMIT, new OrdType('2'));
        typeMap.put(OrderType.STOP, new OrdType('3'));
        typeMap.put(OrderType.STOP_LIMIT, new OrdType('4'));
        tifMap.put(OrderTIF.DAY, new TimeInForce('0'));
        tifMap.put(OrderTIF.IOC, new TimeInForce('3'));
        tifMap.put(OrderTIF.OPG, new TimeInForce('2'));
        tifMap.put(OrderTIF.GTC, new TimeInForce('1'));
        tifMap.put(OrderTIF.GTX, new TimeInForce('5'));
    }

    private static class ObservableLogon
    extends Observable {
        private ObservableLogon() {
        }

        public void logon(SessionID sessionID) {
            this.setChanged();
            this.notifyObservers(new LogonEvent(sessionID, true));
            this.clearChanged();
        }

        public void logoff(SessionID sessionID) {
            this.setChanged();
            this.notifyObservers(new LogonEvent(sessionID, false));
            this.clearChanged();
        }
    }

    private static class ObservableOrder
    extends Observable {
        private ObservableOrder() {
        }

        public void update(Order order) {
            this.setChanged();
            this.notifyObservers(order);
            this.clearChanged();
        }
    }

    public class MessageProcessor
    implements Runnable {
        private final Message message;
        private final SessionID sessionID;

        public MessageProcessor(Message message, SessionID sessionID) {
            this.message = message;
            this.sessionID = sessionID;
        }

        @Override
        public void run() {
            try {
                MsgType msgType = new MsgType();
                if (BanzaiApplication.this.isAvailable) {
                    if (BanzaiApplication.this.isMissingField) {
                        BanzaiApplication.this.sendBusinessReject(this.message, 5, "Conditionally required field missing");
                    } else if (this.message.getHeader().isSetField(128)) {
                        BanzaiApplication.this.sendSessionReject(this.message, 9);
                    } else if (this.message.getHeader().getField((StringField)msgType).valueEquals("8")) {
                        BanzaiApplication.this.executionReport(this.message, this.sessionID);
                    } else if (this.message.getHeader().getField((StringField)msgType).valueEquals("9")) {
                        BanzaiApplication.this.cancelReject(this.message, this.sessionID);
                    } else {
                        BanzaiApplication.this.sendBusinessReject(this.message, 3, "Unsupported Message Type");
                    }
                } else {
                    BanzaiApplication.this.sendBusinessReject(this.message, 4, "Application not available");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

