/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import quickfix.ApplicationExtended;
import quickfix.ApplicationFunctionalAdapter;
import quickfix.SessionID;

public class ApplicationExtendedFunctionalAdapter
extends ApplicationFunctionalAdapter
implements ApplicationExtended {
    private final List<Predicate<SessionID>> canLogonPredicates = new CopyOnWriteArrayList<Predicate<SessionID>>();
    private final List<Consumer<SessionID>> onBeforeSessionResetListeners = new CopyOnWriteArrayList<Consumer<SessionID>>();

    public void addCanLogOnPredicate(Predicate<SessionID> canlogon) {
        this.canLogonPredicates.add(canlogon);
    }

    public void removeCanLogOnPredicate(Predicate<SessionID> canlogon) {
        this.canLogonPredicates.remove(canlogon);
    }

    public void addOnBeforeSessionResetListener(Consumer<SessionID> onBeforeSessionReset) {
        this.onBeforeSessionResetListeners.add(onBeforeSessionReset);
    }

    public void removeBeforeSessionResetListener(Consumer<SessionID> onBeforeSessionReset) {
        this.onBeforeSessionResetListeners.remove(onBeforeSessionReset);
    }

    @Override
    public boolean canLogon(SessionID sessionID) {
        return this.canLogonPredicates.stream().allMatch(p -> p.test(sessionID));
    }

    @Override
    public void onBeforeSessionReset(SessionID sessionID) {
        this.onBeforeSessionResetListeners.forEach(c -> c.accept(sessionID));
    }
}

