/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.CursorFunc;
import com.ziclix.python.sql.DataHandler;
import com.ziclix.python.sql.Fetch;
import com.ziclix.python.sql.Procedure;
import com.ziclix.python.sql.PyConnection;
import com.ziclix.python.sql.PyStatement;
import com.ziclix.python.sql.WarningEvent;
import com.ziclix.python.sql.WarningListener;
import com.ziclix.python.sql.zxJDBC;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;

public class PyCursor
extends PyObject
implements ClassDictInit,
WarningListener {
    protected Fetch fetch;
    private boolean closed = false;
    protected int arraysize = 1;
    protected int softspace = 0;
    protected PyObject rsType = Py.None;
    protected PyObject rsConcur = Py.None;
    protected PyObject warnings;
    protected PyObject lastrowid;
    protected PyObject updatecount;
    protected boolean dynamicFetch;
    protected PyConnection connection;
    protected DataHandler datahandler;
    protected PyStatement statement;
    private static final DataHandler DATAHANDLER = DataHandler.getSystemDataHandler();
    public static PyClass __class__;
    protected static PyList __methods__;
    protected static PyList __members__;

    PyCursor(PyConnection pyConnection) {
        this(pyConnection, false);
    }

    PyCursor(PyConnection pyConnection, boolean bl) {
        this.connection = pyConnection;
        this.datahandler = DATAHANDLER;
        this.dynamicFetch = bl;
        this.clear();
    }

    PyCursor(PyConnection pyConnection, boolean bl, PyObject pyObject, PyObject pyObject2) {
        this(pyConnection, bl);
        this.rsType = pyObject;
        this.rsConcur = pyObject2;
    }

    protected PyClass getPyClass() {
        return __class__;
    }

    public String toString() {
        return "<PyCursor object instance at " + Py.id(this) + ">";
    }

    public void __setattr__(String string, PyObject pyObject) {
        if ("arraysize".equals(string)) {
            this.arraysize = ((PyInteger)pyObject.__int__()).getValue();
        } else if ("softspace".equals(string)) {
            this.softspace = ((PyInteger)pyObject.__int__()).getValue();
        } else if ("datahandler".equals(string)) {
            this.datahandler = (DataHandler)pyObject.__tojava__(DataHandler.class);
        } else {
            super.__setattr__(string, pyObject);
        }
    }

    public PyObject __findattr__(String string) {
        if ("arraysize".equals(string)) {
            return Py.newInteger(this.arraysize);
        }
        if ("softspace".equals(string)) {
            return Py.newInteger(this.softspace);
        }
        if ("__methods__".equals(string)) {
            return __methods__;
        }
        if ("__members__".equals(string)) {
            return __members__;
        }
        if ("description".equals(string)) {
            return this.fetch.description;
        }
        if ("rowcount".equals(string)) {
            return Py.newInteger(this.fetch.rowcount);
        }
        if ("rownumber".equals(string)) {
            int n = this.fetch.rownumber;
            return n < 0 ? Py.None : Py.newInteger(n);
        }
        if ("warnings".equals(string)) {
            return this.warnings;
        }
        if ("lastrowid".equals(string)) {
            return this.lastrowid;
        }
        if ("updatecount".equals(string)) {
            return this.updatecount;
        }
        if ("datahandler".equals(string)) {
            return Py.java2py(this.datahandler);
        }
        if ("dynamic".equals(string)) {
            return this.dynamicFetch ? Py.One : Py.Zero;
        }
        if ("connection".equals(string)) {
            return this.connection;
        }
        if ("closed".equals(string)) {
            return Py.newBoolean(this.closed);
        }
        if ("callproc".equals(string)) {
            try {
                if (!this.getMetaData().supportsStoredProcedures()) {
                    return null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.__findattr__(string);
    }

    public static void classDictInit(PyObject pyObject) {
        pyObject.__setitem__("__version__", Py.newString("$Revision: 3125 $").__getslice__(Py.newInteger(11), Py.newInteger(-2), null));
        pyObject.__setitem__("fetchmany", (PyObject)new CursorFunc("fetchmany", 0, 0, 1, "fetch specified number of rows"));
        pyObject.__setitem__("close", (PyObject)new CursorFunc("close", 1, 0, "close the cursor"));
        pyObject.__setitem__("fetchall", (PyObject)new CursorFunc("fetchall", 2, 0, "fetch all results"));
        pyObject.__setitem__("fetchone", (PyObject)new CursorFunc("fetchone", 3, 0, "fetch the next result"));
        pyObject.__setitem__("nextset", (PyObject)new CursorFunc("nextset", 4, 0, "return next set or None"));
        pyObject.__setitem__("execute", (PyObject)new CursorFunc("execute", 5, 1, 4, "execute the sql expression"));
        pyObject.__setitem__("setinputsizes", (PyObject)new CursorFunc("setinputsizes", 6, 1, "not implemented"));
        pyObject.__setitem__("setoutputsize", (PyObject)new CursorFunc("setoutputsize", 7, 1, 2, "not implemented"));
        pyObject.__setitem__("callproc", (PyObject)new CursorFunc("callproc", 8, 1, 4, "executes a stored procedure"));
        pyObject.__setitem__("executemany", (PyObject)new CursorFunc("executemany", 9, 1, 3, "execute sql with the parameter list"));
        pyObject.__setitem__("scroll", (PyObject)new CursorFunc("scroll", 10, 1, 2, "scroll the cursor in the result set to a new position according to mode"));
        pyObject.__setitem__("write", (PyObject)new CursorFunc("write", 11, 1, "execute the sql written to this file-like object"));
        pyObject.__setitem__("prepare", (PyObject)new CursorFunc("prepare", 12, 1, "prepare the sql statement for later execution"));
        pyObject.__setitem__("classDictInit", null);
        pyObject.__setitem__("toString", null);
        pyObject.__setitem__("getDataHandler", null);
        pyObject.__setitem__("warning", null);
        pyObject.__setitem__("fetch", null);
        pyObject.__setitem__("statement", null);
        pyObject.__setitem__("dynamicFetch", null);
        pyObject.__setitem__("getPyClass", null);
        pyObject.__setitem__("rsConcur", null);
        pyObject.__setitem__("rsType", null);
    }

    public void __del__() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.clear();
            this.connection.remove(this);
        }
        finally {
            this.closed = true;
        }
    }

    public PyObject __iter__() {
        return this;
    }

    public PyObject next() {
        PyObject pyObject = this.__iternext__();
        if (pyObject == null) {
            throw Py.StopIteration("");
        }
        return pyObject;
    }

    public PyObject __iternext__() {
        PyObject pyObject = this.fetchone();
        return pyObject.__nonzero__() ? pyObject : null;
    }

    protected DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.connection.getMetaData();
    }

    public DataHandler getDataHandler() {
        return this.datahandler;
    }

    private PyStatement prepareStatement(PyObject pyObject, PyObject pyObject2, boolean bl) {
        PyStatement pyStatement = null;
        if (pyObject == Py.None) {
            return null;
        }
        try {
            if (pyObject instanceof PyStatement) {
                pyStatement = (PyStatement)pyObject;
            } else {
                int n;
                boolean bl2;
                Statement statement = null;
                String string = pyObject.__str__().toString();
                if (string.trim().length() == 0) {
                    return null;
                }
                boolean bl3 = bl2 = this.rsType == Py.None && this.rsConcur == Py.None;
                if (bl2) {
                    statement = bl ? this.connection.connection.prepareStatement(string) : this.connection.connection.createStatement();
                } else {
                    n = ((PyInteger)this.rsType.__int__()).getValue();
                    int n2 = ((PyInteger)this.rsConcur.__int__()).getValue();
                    statement = bl ? this.connection.connection.prepareStatement(string, n, n2) : this.connection.connection.createStatement(n, n2);
                }
                n = bl ? 4 : 2;
                pyStatement = new PyStatement(statement, string, n);
            }
            if (pyObject2 != Py.None) {
                pyStatement.statement.setMaxRows(((PyInteger)pyObject2.__int__()).getValue());
            }
        }
        catch (AbstractMethodError abstractMethodError) {
            throw zxJDBC.makeException(zxJDBC.NotSupportedError, zxJDBC.getString("nodynamiccursors"));
        }
        catch (PyException pyException) {
            throw pyException;
        }
        catch (Throwable throwable) {
            throw zxJDBC.makeException(throwable);
        }
        return pyStatement;
    }

    public void callproc(PyObject pyObject, PyObject pyObject2, PyObject pyObject3, PyObject pyObject4) {
        block11: {
            this.clear();
            try {
                if (this.getMetaData().supportsStoredProcedures()) {
                    if (PyCursor.isSeqSeq(pyObject2)) {
                        throw zxJDBC.makeException(zxJDBC.NotSupportedError, "sequence of sequences is not supported");
                    }
                    Procedure procedure = this.datahandler.getProcedure(this, pyObject);
                    CallableStatement callableStatement = procedure.prepareCall(this.rsType, this.rsConcur);
                    if (pyObject4 != Py.None) {
                        callableStatement.setMaxRows(((PyInteger)pyObject4.__int__()).getValue());
                    }
                    PyDictionary pyDictionary = new PyDictionary();
                    procedure.normalizeInput(pyObject2, pyDictionary);
                    if (pyObject3 instanceof PyDictionary) {
                        pyDictionary.update((PyDictionary)pyObject3);
                    }
                    this.statement = new PyStatement(callableStatement, procedure);
                    this.execute(pyObject2, pyDictionary);
                    break block11;
                }
                throw zxJDBC.makeException(zxJDBC.NotSupportedError, zxJDBC.getString("noStoredProc"));
            }
            catch (PyException pyException) {
                throw pyException;
            }
            catch (Throwable throwable) {
                throw zxJDBC.makeException(throwable);
            }
            finally {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
        }
    }

    public void executemany(PyObject pyObject, PyObject pyObject2, PyObject pyObject3, PyObject pyObject4) {
        this.execute(pyObject, pyObject2, pyObject3, pyObject4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(PyObject pyObject, PyObject pyObject2, PyObject pyObject3, PyObject pyObject4) {
        this.clear();
        boolean bl = PyCursor.hasParams(pyObject2);
        PyStatement pyStatement = this.prepareStatement(pyObject, pyObject4, bl);
        if (pyStatement == null) {
            return;
        }
        this.statement = pyStatement;
        try {
            PyStatement pyStatement2 = this.statement;
            synchronized (pyStatement2) {
                if (bl) {
                    if (PyCursor.isSeqSeq(pyObject2)) {
                        int n = pyObject2.__len__();
                        for (int i = 0; i < n; ++i) {
                            PyObject pyObject5 = pyObject2.__getitem__(i);
                            this.execute(pyObject5, pyObject3);
                        }
                    } else {
                        this.execute(pyObject2, pyObject3);
                    }
                } else {
                    this.execute(Py.None, Py.None);
                }
            }
        }
        catch (PyException pyException) {
            throw pyException;
        }
        catch (Throwable throwable) {
            throw zxJDBC.makeException(throwable);
        }
        finally {
            if (this.statement != null && !(pyObject instanceof PyStatement) && !this.dynamicFetch) {
                this.statement.close();
            }
        }
    }

    protected void execute(PyObject pyObject, PyObject pyObject2) {
        try {
            Statement statement = this.statement.statement;
            this.datahandler.preExecute(statement);
            this.statement.execute(this, pyObject, pyObject2);
            this.lastrowid = this.datahandler.getRowId(statement);
            int n = statement.getUpdateCount();
            this.updatecount = n < 0 ? Py.None : Py.newInteger(n);
            this.warning(new WarningEvent(this, statement.getWarnings()));
            this.datahandler.postExecute(statement);
        }
        catch (PyException pyException) {
            throw pyException;
        }
        catch (Throwable throwable) {
            throw zxJDBC.makeException(throwable);
        }
    }

    public PyObject fetchone() {
        return this.fetch.fetchone();
    }

    public PyObject fetchall() {
        return this.fetch.fetchall();
    }

    public PyObject fetchmany(int n) {
        return this.fetch.fetchmany(n);
    }

    public PyObject nextset() {
        return this.fetch.nextset();
    }

    public PyStatement prepare(PyObject pyObject) {
        PyStatement pyStatement = this.prepareStatement(pyObject, Py.None, true);
        this.connection.add(pyStatement);
        return pyStatement;
    }

    public void scroll(int n, String string) {
        this.fetch.scroll(n, string);
    }

    public void warning(WarningEvent warningEvent) {
        if (this.warnings == Py.None) {
            this.warnings = new PyList();
        }
        for (SQLWarning sQLWarning = warningEvent.getWarning(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
            PyObject[] pyObjectArray = new PyObject[]{Py.java2py(sQLWarning.getMessage()), Py.java2py(sQLWarning.getSQLState()), Py.newInteger(sQLWarning.getErrorCode())};
            ((PyList)this.warnings).append(new PyTuple(pyObjectArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        if (this.closed) {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, "cursor is closed");
        }
        this.warnings = Py.None;
        this.lastrowid = Py.None;
        this.updatecount = Py.newInteger(-1);
        try {
            this.fetch.close();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.fetch = Fetch.newFetch(this.datahandler, this.dynamicFetch);
            this.fetch.addWarningListener(this);
        }
        if (this.statement != null) {
            try {
                if (this.dynamicFetch && !this.connection.contains(this.statement)) {
                    this.statement.close();
                }
            }
            finally {
                this.statement = null;
            }
        }
    }

    public static boolean isSeq(PyObject pyObject) {
        if (pyObject == null || pyObject == Py.None) {
            return false;
        }
        if (pyObject.__tojava__(List.class) != Py.NoConversion) {
            return true;
        }
        return pyObject instanceof PyList || pyObject instanceof PyTuple;
    }

    public static boolean hasParams(PyObject pyObject) {
        if (Py.None == pyObject) {
            return false;
        }
        boolean bl = PyCursor.isSeq(pyObject);
        if (!bl) {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, zxJDBC.getString("optionalSecond"));
        }
        return pyObject.__len__() > 0;
    }

    public static boolean isSeqSeq(PyObject pyObject) {
        if (PyCursor.isSeq(pyObject) && pyObject.__len__() > 0) {
            for (int i = 0; i < pyObject.__len__(); ++i) {
                if (PyCursor.isSeq(pyObject.__finditem__(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        PyObject[] pyObjectArray = new PyObject[]{new PyString("close"), new PyString("execute"), new PyString("executemany"), new PyString("fetchone"), new PyString("fetchall"), new PyString("fetchmany"), new PyString("callproc"), new PyString("next"), new PyString("write")};
        __methods__ = new PyList(pyObjectArray);
        pyObjectArray = new PyObject[]{new PyString("arraysize"), new PyString("rowcount"), new PyString("rownumber"), new PyString("description"), new PyString("datahandler"), new PyString("warnings"), new PyString("lastrowid"), new PyString("updatecount"), new PyString("softspace"), new PyString("closed"), new PyString("connection")};
        __members__ = new PyList(pyObjectArray);
    }
}

