/*
 * Decompiled with CFR 0.152.
 */
package org.python.antlr;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.antlr.runtime.Token;
import org.python.antlr.ErrorHandler;
import org.python.antlr.PythonParser;
import org.python.antlr.PythonTree;
import org.python.antlr.ast.Attribute;
import org.python.antlr.ast.BinOp;
import org.python.antlr.ast.BoolOp;
import org.python.antlr.ast.Call;
import org.python.antlr.ast.Context;
import org.python.antlr.ast.DictComp;
import org.python.antlr.ast.ExtSlice;
import org.python.antlr.ast.For;
import org.python.antlr.ast.FunctionDef;
import org.python.antlr.ast.GeneratorExp;
import org.python.antlr.ast.IfExp;
import org.python.antlr.ast.Index;
import org.python.antlr.ast.Lambda;
import org.python.antlr.ast.List;
import org.python.antlr.ast.ListComp;
import org.python.antlr.ast.Name;
import org.python.antlr.ast.Num;
import org.python.antlr.ast.Repr;
import org.python.antlr.ast.SetComp;
import org.python.antlr.ast.Slice;
import org.python.antlr.ast.Str;
import org.python.antlr.ast.TryExcept;
import org.python.antlr.ast.TryFinally;
import org.python.antlr.ast.Tuple;
import org.python.antlr.ast.UnaryOp;
import org.python.antlr.ast.While;
import org.python.antlr.ast.With;
import org.python.antlr.ast.Yield;
import org.python.antlr.ast.alias;
import org.python.antlr.ast.arguments;
import org.python.antlr.ast.boolopType;
import org.python.antlr.ast.cmpopType;
import org.python.antlr.ast.expr_contextType;
import org.python.antlr.ast.keyword;
import org.python.antlr.ast.operatorType;
import org.python.antlr.ast.unaryopType;
import org.python.antlr.base.excepthandler;
import org.python.antlr.base.expr;
import org.python.antlr.base.slice;
import org.python.antlr.base.stmt;
import org.python.core.Py;
import org.python.core.PyComplex;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyString;
import org.python.core.PyUnicode;
import org.python.core.codecs;
import org.python.core.util.StringUtil;

public class GrammarActions {
    private ErrorHandler errorHandler = null;

    public void setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
    }

    String makeFromText(java.util.List dots, java.util.List<Name> names) {
        StringBuilder d = new StringBuilder();
        d.append(PythonTree.dottedNameListToString(names));
        return d.toString();
    }

    java.util.List<Name> makeModuleNameNode(java.util.List dots, java.util.List<Name> names) {
        ArrayList<Name> result2 = new ArrayList<Name>();
        if (dots != null) {
            for (Object o : dots) {
                Token tok = (Token)o;
                result2.add(new Name(tok, tok.getText(), expr_contextType.Load));
            }
        }
        if (null != names) {
            result2.addAll(names);
        }
        return result2;
    }

    java.util.List<Name> makeDottedName(Token top, java.util.List<PythonTree> attrs) {
        ArrayList<Name> result2 = new ArrayList<Name>();
        result2.add(new Name(top, top.getText(), expr_contextType.Load));
        if (attrs != null) {
            for (PythonTree attr : attrs) {
                Token token2 = attr.getToken();
                result2.add(new Name(token2, token2.getText(), expr_contextType.Load));
            }
        }
        return result2;
    }

    int makeLevel(java.util.List lev) {
        if (lev == null) {
            return 0;
        }
        return lev.size();
    }

    java.util.List<alias> makeStarAlias(Token t) {
        ArrayList<alias> result2 = new ArrayList<alias>();
        result2.add(new alias(t, "*", null));
        return result2;
    }

    java.util.List<alias> makeAliases(java.util.List<alias> atypes) {
        if (atypes == null) {
            return new ArrayList<alias>();
        }
        return atypes;
    }

    java.util.List<expr> makeBases(expr etype) {
        ArrayList<expr> result2 = new ArrayList<expr>();
        if (etype != null) {
            if (etype instanceof Tuple) {
                return ((Tuple)etype).getInternalElts();
            }
            result2.add(etype);
        }
        return result2;
    }

    java.util.List<String> makeNames(java.util.List<Token> names) {
        ArrayList<String> s = new ArrayList<String>();
        for (Token name : names) {
            s.add(name.getText());
        }
        return s;
    }

    Name makeNameNode(Token t) {
        if (t == null) {
            return null;
        }
        return new Name(t, t.getText(), expr_contextType.Load);
    }

    java.util.List<Name> makeNameNodes(java.util.List<Token> names) {
        ArrayList<Name> s = new ArrayList<Name>();
        for (Token name : names) {
            s.add(this.makeNameNode(name));
        }
        return s;
    }

    void errorGenExpNotSoleArg(PythonTree t) {
        this.errorHandler.error("Generator expression must be parenthesized if not sole argument", t);
    }

    expr castExpr(Object o) {
        if (o instanceof expr) {
            return (expr)o;
        }
        if (o instanceof PythonTree) {
            return this.errorHandler.errorExpr((PythonTree)o);
        }
        return null;
    }

    java.util.List<expr> castExprs(java.util.List exprs) {
        return this.castExprs(exprs, 0);
    }

    java.util.List<expr> castExprs(java.util.List exprs, int start) {
        ArrayList<expr> result2 = new ArrayList<expr>();
        if (exprs != null) {
            for (int i = start; i < exprs.size(); ++i) {
                Object o = exprs.get(i);
                if (o instanceof expr) {
                    result2.add((expr)o);
                    continue;
                }
                if (!(o instanceof PythonParser.test_return)) continue;
                result2.add((expr)((PythonParser.test_return)((Object)o)).tree);
            }
        }
        return result2;
    }

    java.util.List<stmt> makeElse(java.util.List elseSuite, PythonTree elif) {
        if (elseSuite != null) {
            return this.castStmts(elseSuite);
        }
        if (elif == null) {
            return new ArrayList<stmt>();
        }
        ArrayList<stmt> s = new ArrayList<stmt>();
        s.add(this.castStmt(elif));
        return s;
    }

    stmt castStmt(Object o) {
        if (o instanceof stmt) {
            return (stmt)o;
        }
        if (o instanceof PythonParser.stmt_return) {
            return (stmt)((PythonParser.stmt_return)((Object)o)).tree;
        }
        if (o instanceof PythonTree) {
            return this.errorHandler.errorStmt((PythonTree)o);
        }
        return null;
    }

    java.util.List<stmt> castStmts(PythonTree t) {
        stmt s = (stmt)t;
        ArrayList<stmt> stmts = new ArrayList<stmt>();
        stmts.add(s);
        return stmts;
    }

    java.util.List<stmt> castStmts(java.util.List stmts) {
        if (stmts != null) {
            ArrayList<stmt> result2 = new ArrayList<stmt>();
            for (Object o : stmts) {
                result2.add(this.castStmt(o));
            }
            return result2;
        }
        return new ArrayList<stmt>();
    }

    expr makeDottedAttr(Token nameToken, java.util.List attrs) {
        expr current = new Name(nameToken, nameToken.getText(), expr_contextType.Load);
        for (Object o : attrs) {
            Token t = (Token)o;
            current = new Attribute(t, current, this.cantBeNoneName(t), expr_contextType.Load);
        }
        return current;
    }

    stmt makeWhile(Token t, expr test, java.util.List body, java.util.List orelse) {
        if (test == null) {
            return this.errorHandler.errorStmt(new PythonTree(t));
        }
        java.util.List<stmt> o = this.castStmts(orelse);
        java.util.List<stmt> b = this.castStmts(body);
        return new While(t, test, b, o);
    }

    stmt makeWith(Token t, java.util.List<With> items, java.util.List<stmt> body) {
        int last = items.size() - 1;
        With result2 = null;
        for (int i = last; i >= 0; --i) {
            With current = items.get(i);
            if (i != last) {
                body = new ArrayList<stmt>();
                body.add(result2);
            }
            result2 = new With(current.getToken(), current.getInternalContext_expr(), current.getInternalOptional_vars(), body);
        }
        return result2;
    }

    stmt makeFor(Token t, expr target, expr iter, java.util.List body, java.util.List orelse) {
        if (target == null || iter == null) {
            return this.errorHandler.errorStmt(new PythonTree(t));
        }
        this.cantBeNone(target);
        java.util.List<stmt> o = this.castStmts(orelse);
        java.util.List<stmt> b = this.castStmts(body);
        return new For(t, target, iter, b, o);
    }

    stmt makeTryExcept(Token t, java.util.List body, java.util.List<excepthandler> handlers2, java.util.List orelse, java.util.List finBody) {
        java.util.List<stmt> b = this.castStmts(body);
        java.util.List<excepthandler> e = handlers2;
        java.util.List<stmt> o = this.castStmts(orelse);
        TryExcept te = new TryExcept(t, b, e, o);
        if (finBody == null) {
            return te;
        }
        java.util.List<stmt> f = this.castStmts(finBody);
        ArrayList<stmt> mainBody = new ArrayList<stmt>();
        mainBody.add(te);
        return new TryFinally(t, mainBody, f);
    }

    TryFinally makeTryFinally(Token t, java.util.List body, java.util.List finBody) {
        java.util.List<stmt> b = this.castStmts(body);
        java.util.List<stmt> f = this.castStmts(finBody);
        return new TryFinally(t, b, f);
    }

    stmt makeFuncdef(Token t, Token nameToken, arguments args, java.util.List funcStatements, java.util.List decorators) {
        if (nameToken == null) {
            return this.errorHandler.errorStmt(new PythonTree(t));
        }
        Name n = this.cantBeNoneName(nameToken);
        arguments a = args != null ? args : new arguments(t, new ArrayList<expr>(), (Name)null, null, new ArrayList<expr>());
        java.util.List<stmt> s = this.castStmts(funcStatements);
        java.util.List<expr> d = this.castExprs(decorators);
        return new FunctionDef(t, n, a, s, d);
    }

    java.util.List<expr> makeAssignTargets(expr lhs, java.util.List rhs) {
        ArrayList<expr> e = new ArrayList<expr>();
        this.checkAssign(lhs);
        e.add(lhs);
        for (int i = 0; i < rhs.size() - 1; ++i) {
            expr r = this.castExpr(rhs.get(i));
            this.checkAssign(r);
            e.add(r);
        }
        return e;
    }

    expr makeAssignValue(java.util.List rhs) {
        expr value = this.castExpr(rhs.get(rhs.size() - 1));
        this.recurseSetContext(value, expr_contextType.Load);
        return value;
    }

    void recurseSetContext(PythonTree tree, expr_contextType context) {
        if (tree instanceof Context) {
            ((Context)((Object)tree)).setContext(context);
        }
        if (tree instanceof GeneratorExp) {
            GeneratorExp g = (GeneratorExp)tree;
            this.recurseSetContext(g.getInternalElt(), context);
        } else if (tree instanceof ListComp) {
            ListComp lc = (ListComp)tree;
            this.recurseSetContext(lc.getInternalElt(), context);
        } else if (tree instanceof SetComp) {
            SetComp sc = (SetComp)tree;
            this.recurseSetContext(sc.getInternalElt(), context);
        } else if (tree instanceof DictComp) {
            DictComp dc = (DictComp)tree;
            this.recurseSetContext(dc.getInternalKey(), context);
            this.recurseSetContext(dc.getInternalValue(), context);
        } else if (!(tree instanceof ListComp || tree instanceof DictComp || tree instanceof SetComp)) {
            for (int i = 0; i < tree.getChildCount(); ++i) {
                this.recurseSetContext(tree.getChild(i), context);
            }
        }
    }

    arguments makeArgumentsType(Token t, java.util.List params, Token snameToken, Token knameToken, java.util.List defaults) {
        java.util.List<expr> p = this.castExprs(params);
        java.util.List<expr> d = this.castExprs(defaults);
        Name s = snameToken == null ? null : this.cantBeNoneName(snameToken);
        Name k = knameToken == null ? null : this.cantBeNoneName(knameToken);
        return new arguments(t, p, s, k, d);
    }

    java.util.List<expr> extractArgs(java.util.List args) {
        return this.castExprs(args);
    }

    java.util.List<keyword> makeKeywords(java.util.List args) {
        ArrayList<keyword> keywords = new ArrayList<keyword>();
        if (args != null) {
            for (Object o : args) {
                java.util.List e = (java.util.List)o;
                Object k = e.get(0);
                Object v = e.get(1);
                this.checkAssign(this.castExpr(k));
                if (k instanceof Name) {
                    Name arg = (Name)k;
                    keywords.add(new keyword(arg, arg.getInternalId(), this.castExpr(v)));
                    continue;
                }
                this.errorHandler.error("keyword must be a name", (PythonTree)k);
            }
        }
        return keywords;
    }

    Object makeFloat(Token t) {
        return Py.newFloat(Double.valueOf(t.getText()));
    }

    Object makeComplex(Token t) {
        String s = t.getText();
        s = s.substring(0, s.length() - 1);
        return Py.newImaginary(Double.valueOf(s));
    }

    Object makeInt(Token t) {
        int i;
        String s = t.getText();
        int radix = 10;
        if (s.startsWith("0x") || s.startsWith("0X")) {
            radix = 16;
            s = s.substring(2, s.length());
        } else if (s.startsWith("0o") || s.startsWith("0O")) {
            radix = 8;
            s = s.substring(2, s.length());
        } else if (s.startsWith("0b") || s.startsWith("0B")) {
            radix = 2;
            s = s.substring(2, s.length());
        } else if (s.startsWith("0")) {
            radix = 8;
        }
        if (s.endsWith("L") || s.endsWith("l")) {
            s = s.substring(0, s.length() - 1);
            return Py.newLong(new BigInteger(s, radix));
        }
        int ndigits = s.length();
        for (i = 0; i < ndigits && s.charAt(i) == '0'; ++i) {
        }
        if (ndigits - i > 11) {
            return Py.newLong(new BigInteger(s, radix));
        }
        long l = Long.valueOf(s, radix);
        if (l > 0xFFFFFFFFL || l > Integer.MAX_VALUE) {
            return Py.newLong(new BigInteger(s, radix));
        }
        return Py.newInteger((int)l);
    }

    PyString extractStrings(java.util.List s, String encoding, boolean unicodeLiterals) {
        boolean ustring = false;
        Token last2 = null;
        StringBuffer sb = new StringBuffer();
        for (Token last2 : s) {
            StringPair sp = this.extractString(last2, encoding, unicodeLiterals);
            if (sp.isUnicode()) {
                ustring = true;
            }
            sb.append(sp.getString());
        }
        if (ustring) {
            return new PyUnicode(sb.toString());
        }
        return new PyString(sb.toString());
    }

    StringPair extractString(Token t, String encoding, boolean unicodeLiterals) {
        String string2 = t.getText();
        char quoteChar = string2.charAt(0);
        int start = 0;
        boolean ustring = unicodeLiterals;
        if (quoteChar == 'u' || quoteChar == 'U') {
            ustring = true;
            ++start;
        }
        if (quoteChar == 'b' || quoteChar == 'B') {
            ustring = false;
            ++start;
        }
        quoteChar = string2.charAt(start);
        boolean raw = false;
        if (quoteChar == 'r' || quoteChar == 'R') {
            raw = true;
            ++start;
        }
        int quotes = 3;
        if (string2.length() - start == 2) {
            quotes = 1;
        }
        if (string2.charAt(start) != string2.charAt(start + 1)) {
            quotes = 1;
        }
        start = quotes + start;
        int end = string2.length() - quotes;
        if (!ustring && encoding != null) {
            Charset cs = Charset.forName(encoding);
            ByteBuffer decoded = cs.encode(string2.substring(start, end));
            string2 = StringUtil.fromBytes(decoded);
            if (!raw) {
                string2 = PyString.decode_UnicodeEscape(string2, 0, string2.length(), "strict", ustring);
            }
        } else if (raw) {
            string2 = string2.substring(start, end);
            if (ustring) {
                string2 = codecs.PyUnicode_DecodeRawUnicodeEscape(string2, "strict");
            }
        } else {
            string2 = PyString.decode_UnicodeEscape(string2, start, end, "strict", ustring);
        }
        return new StringPair(string2, ustring);
    }

    Token extractStringToken(java.util.List s) {
        return (Token)s.get(0);
    }

    expr makeCall(Token t, expr func) {
        return this.makeCall(t, func, null, null, null, null);
    }

    expr makeCall(Token t, expr func, java.util.List args, java.util.List keywords, expr starargs, expr kwargs) {
        if (func == null) {
            return this.errorHandler.errorExpr(new PythonTree(t));
        }
        java.util.List<keyword> k = this.makeKeywords(keywords);
        java.util.List<expr> a = this.castExprs(args);
        return new Call(t, func, a, k, starargs, kwargs);
    }

    expr negate(Token t, expr o) {
        return this.negate(new PythonTree(t), o);
    }

    expr negate(PythonTree t, expr o) {
        if (o instanceof Num) {
            double v;
            Num num = (Num)o;
            if (num.getInternalN() instanceof PyInteger) {
                int v2 = ((PyInteger)num.getInternalN()).getValue();
                if (v2 >= 0) {
                    num.setN(new PyInteger(-v2));
                    return num;
                }
            } else if (num.getInternalN() instanceof PyLong) {
                BigInteger v3 = ((PyLong)num.getInternalN()).getValue();
                if (v3.compareTo(BigInteger.ZERO) == 1) {
                    num.setN(new PyLong(v3.negate()));
                    return num;
                }
            } else if (num.getInternalN() instanceof PyFloat) {
                double v4 = ((PyFloat)num.getInternalN()).getValue();
                if (v4 >= 0.0) {
                    num.setN(new PyFloat(-v4));
                    return num;
                }
            } else if (num.getInternalN() instanceof PyComplex && (v = ((PyComplex)num.getInternalN()).imag) >= 0.0) {
                num.setN(new PyComplex(0.0, -v));
                return num;
            }
        }
        return new UnaryOp(t, unaryopType.USub, o);
    }

    String cantBeNone(Token t) {
        if (t == null || t.getText().equals("None")) {
            this.errorHandler.error("can't be None", new PythonTree(t));
        }
        return t.getText();
    }

    Name cantBeNoneName(Token t) {
        if (t == null || t.getText().equals("None")) {
            this.errorHandler.error("can't be None", new PythonTree(t));
        }
        return new Name(t, t.getText(), expr_contextType.Load);
    }

    void cantBeNone(PythonTree e) {
        if (e.getText().equals("None")) {
            this.errorHandler.error("can't be None", e);
        }
    }

    private void checkGenericAssign(expr e) {
        if (e instanceof Name && ((Name)e).getInternalId().equals("None")) {
            this.errorHandler.error("assignment to None", e);
        } else if (e instanceof GeneratorExp) {
            this.errorHandler.error("can't assign to generator expression", e);
        } else if (e instanceof Num) {
            this.errorHandler.error("can't assign to number", e);
        } else if (e instanceof Str) {
            this.errorHandler.error("can't assign to string", e);
        } else if (e instanceof Yield) {
            this.errorHandler.error("can't assign to yield expression", e);
        } else if (e instanceof BinOp) {
            this.errorHandler.error("can't assign to operator", e);
        } else if (e instanceof BoolOp) {
            this.errorHandler.error("can't assign to operator", e);
        } else if (e instanceof Lambda) {
            this.errorHandler.error("can't assign to lambda", e);
        } else if (e instanceof Call) {
            this.errorHandler.error("can't assign to function call", e);
        } else if (e instanceof Repr) {
            this.errorHandler.error("can't assign to repr", e);
        } else if (e instanceof IfExp) {
            this.errorHandler.error("can't assign to conditional expression", e);
        } else if (e instanceof ListComp) {
            this.errorHandler.error("can't assign to list comprehension", e);
        } else if (e instanceof SetComp) {
            this.errorHandler.error("can't assign to set comprehension", e);
        } else if (e instanceof DictComp) {
            this.errorHandler.error("can't assign to dict comprehension", e);
        }
    }

    void checkAugAssign(expr e) {
        this.checkGenericAssign(e);
        if (e instanceof Tuple) {
            this.errorHandler.error("assignment to tuple illegal for augmented assignment", e);
        } else if (e instanceof List) {
            this.errorHandler.error("assignment to list illegal for augmented assignment", e);
        }
    }

    void checkAssign(expr e) {
        block4: {
            block3: {
                this.checkGenericAssign(e);
                if (!(e instanceof Tuple)) break block3;
                java.util.List<expr> elts = ((Tuple)e).getInternalElts();
                if (elts.size() == 0) {
                    this.errorHandler.error("can't assign to ()", e);
                }
                for (int i = 0; i < elts.size(); ++i) {
                    this.checkAssign(elts.get(i));
                }
                break block4;
            }
            if (!(e instanceof List)) break block4;
            java.util.List<expr> elts = ((List)e).getInternalElts();
            for (int i = 0; i < elts.size(); ++i) {
                this.checkAssign(elts.get(i));
            }
        }
    }

    java.util.List<expr> makeDeleteList(java.util.List deletes) {
        java.util.List<expr> exprs = this.castExprs(deletes);
        for (expr e : exprs) {
            this.checkDelete(e);
        }
        return exprs;
    }

    void checkDelete(expr e) {
        block4: {
            block7: {
                block6: {
                    block5: {
                        block3: {
                            if (!(e instanceof Call)) break block3;
                            this.errorHandler.error("can't delete function call", e);
                            break block4;
                        }
                        if (!(e instanceof Num)) break block5;
                        this.errorHandler.error("can't delete number", e);
                        break block4;
                    }
                    if (!(e instanceof Str)) break block6;
                    this.errorHandler.error("can't delete string", e);
                    break block4;
                }
                if (!(e instanceof Tuple)) break block7;
                java.util.List<expr> elts = ((Tuple)e).getInternalElts();
                if (elts.size() == 0) {
                    this.errorHandler.error("can't delete ()", e);
                }
                for (int i = 0; i < elts.size(); ++i) {
                    this.checkDelete(elts.get(i));
                }
                break block4;
            }
            if (!(e instanceof List)) break block4;
            java.util.List<expr> elts = ((List)e).getInternalElts();
            for (int i = 0; i < elts.size(); ++i) {
                this.checkDelete(elts.get(i));
            }
        }
    }

    slice makeSubscript(PythonTree lower, Token colon, PythonTree upper, PythonTree sliceop) {
        boolean isSlice = false;
        expr s = null;
        expr e = null;
        expr o = null;
        if (lower != null) {
            s = this.castExpr(lower);
        }
        if (colon != null) {
            isSlice = true;
            if (upper != null) {
                e = this.castExpr(upper);
            }
        }
        if (sliceop != null) {
            isSlice = true;
            o = sliceop != null ? this.castExpr(sliceop) : new Name(sliceop, "None", expr_contextType.Load);
        }
        PythonTree tok = lower;
        if (lower == null) {
            tok = new PythonTree(colon);
        }
        if (isSlice) {
            return new Slice(tok, s, e, o);
        }
        return new Index(tok, s);
    }

    java.util.List<cmpopType> makeCmpOps(java.util.List cmps) {
        ArrayList<cmpopType> result2 = new ArrayList<cmpopType>();
        if (cmps != null) {
            for (Object o : cmps) {
                result2.add((cmpopType)((Object)o));
            }
        }
        return result2;
    }

    BoolOp makeBoolOp(Token t, PythonTree left, boolopType op, java.util.List right) {
        ArrayList<PythonTree> values = new ArrayList<PythonTree>();
        values.add(left);
        values.addAll(right);
        return new BoolOp(t, op, this.castExprs(values));
    }

    BinOp makeBinOp(Token t, PythonTree left, operatorType op, java.util.List rights) {
        BinOp current = new BinOp(t, this.castExpr(left), op, this.castExpr(rights.get(0)));
        for (int i = 1; i < rights.size(); ++i) {
            expr right = this.castExpr(rights.get(i));
            current = new BinOp(left, (expr)current, op, right);
        }
        return current;
    }

    BinOp makeBinOp(Token t, PythonTree left, java.util.List ops, java.util.List rights, java.util.List toks) {
        BinOp current = new BinOp(t, this.castExpr(left), (operatorType)((Object)ops.get(0)), this.castExpr(rights.get(0)));
        for (int i = 1; i < rights.size(); ++i) {
            expr right = this.castExpr(rights.get(i));
            operatorType op = (operatorType)((Object)ops.get(i));
            current = new BinOp((Token)toks.get(i), (expr)current, op, right);
        }
        return current;
    }

    java.util.List<slice> castSlices(java.util.List slices) {
        ArrayList<slice> result2 = new ArrayList<slice>();
        if (slices != null) {
            for (Object o : slices) {
                result2.add(this.castSlice(o));
            }
        }
        return result2;
    }

    slice castSlice(Object o) {
        if (o instanceof slice) {
            return (slice)o;
        }
        return this.errorHandler.errorSlice((PythonTree)o);
    }

    slice makeSliceType(Token begin, Token c1, Token c2, java.util.List sltypes) {
        boolean isTuple = false;
        if (c1 != null || c2 != null) {
            isTuple = true;
        }
        slice s = null;
        boolean extslice = false;
        if (isTuple) {
            ArrayList<expr> etypes = new ArrayList<expr>();
            for (Object o : sltypes) {
                if (o instanceof Index) {
                    Index i = (Index)o;
                    etypes.add(i.getInternalValue());
                    continue;
                }
                extslice = true;
                break;
            }
            if (!extslice) {
                Tuple t = new Tuple(begin, etypes, expr_contextType.Load);
                s = new Index(begin, (expr)t);
            }
        } else if (sltypes.size() == 1) {
            s = this.castSlice(sltypes.get(0));
        } else if (sltypes.size() != 0) {
            extslice = true;
        }
        if (extslice) {
            java.util.List<slice> st = this.castSlices(sltypes);
            s = new ExtSlice(begin, st);
        }
        return s;
    }

    class StringPair {
        private String s;
        private boolean unicode;

        StringPair(String s, boolean unicode) {
            this.s = s;
            this.unicode = unicode;
        }

        String getString() {
            return this.s;
        }

        boolean isUnicode() {
            return this.unicode;
        }
    }
}

