/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component.html;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractInputComponent;

public abstract class SelectOneMenu
extends AbstractInputComponent {
    public void deselect(String label) {
        if (!this.isSelected(label) || !this.isEnabled()) {
            return;
        }
        WebElement option = this.getOptions().stream().filter(e -> Objects.equals(e.getDomProperty("innerHTML"), label) && e.isSelected()).findFirst().orElse(null);
        if (option != null) {
            if (this.isAjaxified("onchange")) {
                option = (WebElement)PrimeSelenium.guardAjax((Object)option);
            }
            option.click();
        }
    }

    public void select(String label) {
        if (this.isSelected(label) || !this.isEnabled()) {
            return;
        }
        WebElement option = this.getOptions().stream().filter(e -> Objects.equals(e.getDomProperty("innerHTML"), label) && !e.isSelected()).findFirst().orElse(null);
        if (option != null) {
            if (this.isAjaxified("onchange")) {
                option = (WebElement)PrimeSelenium.guardAjax((Object)option);
            }
            option.click();
        }
    }

    public String getSelectedLabel() {
        WebElement option = this.getOptions().stream().filter(e -> e.isSelected()).findFirst().orElse(null);
        return option == null ? null : option.getDomProperty("innerHTML");
    }

    public boolean isSelected(String label) {
        boolean result = false;
        try {
            result = this.getSelectedLabel().equalsIgnoreCase(label);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public List<String> getLabels() {
        return this.getOptions().stream().map(e -> e.getDomProperty("innerHTML")).collect(Collectors.toList());
    }

    public List<WebElement> getOptions() {
        return this.getRoot().findElements(By.tagName((String)"option"));
    }

    public void select(int index) {
        if (this.isSelected(index)) {
            return;
        }
        this.select(this.getLabel(index));
    }

    public void deselect(int index) {
        if (!this.isSelected(index)) {
            return;
        }
        this.deselect(this.getLabel(index));
    }

    public boolean isSelected(int index) {
        return this.getLabel(index).equals(this.getSelectedLabel());
    }

    public String getLabel(int index) {
        return this.getLabels().get(index);
    }

    @Override
    public WebElement getInput() {
        return this.getRoot();
    }
}

