/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractComponent;
import org.primefaces.selenium.component.base.ComponentUtils;
import org.primefaces.selenium.component.model.Tab;

public abstract class TabView
extends AbstractComponent {
    @FindBy(css=".ui-tabs-header")
    private List<WebElement> headers;
    @FindBy(css=".ui-tabs-panel")
    private List<WebElement> contents;
    private List<Tab> tabs = null;

    public List<Tab> getTabs() {
        if (this.tabs == null) {
            ArrayList<Tab> tabs = new ArrayList<Tab>();
            this.headers.forEach(headerElt -> {
                String title = headerElt.findElement(By.tagName((String)"a")).getText();
                int index = this.getIndexOfHeader((WebElement)headerElt);
                WebElement content = this.contents.get(index);
                tabs.add(new Tab(title, index, (WebElement)headerElt, content));
            });
            this.tabs = tabs;
        }
        return this.tabs;
    }

    public void toggleTab(int index) {
        boolean isDynamic;
        JSONObject cfg = this.getWidgetConfiguration();
        boolean bl = isDynamic = cfg.has("dynamic") && cfg.getBoolean("dynamic");
        if (isDynamic || ComponentUtils.hasAjaxBehavior(this.getRoot(), "tabChange")) {
            ((WebElement)PrimeSelenium.guardAjax((Object)this.headers.get(index))).click();
        } else {
            this.headers.get(index).click();
        }
    }

    public Tab getSelectedTab() {
        WebElement selectedTabHeader = this.findElement(By.className((String)"ui-tabs-selected"));
        int index = this.getIndexOfHeader(selectedTabHeader);
        return this.getTabs().get(index);
    }

    private Integer getIndexOfHeader(WebElement headerElt) {
        return Integer.parseInt(headerElt.getDomAttribute("data-index"));
    }
}

