/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component;

import java.io.Serializable;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractInputComponent;
import org.primefaces.selenium.component.base.ComponentUtils;

public abstract class InputText
extends AbstractInputComponent {
    public String getValue() {
        return this.getInput().getDomProperty("value");
    }

    public void setValue(Serializable value) {
        boolean ajaxified = this.isOnchangeAjaxified();
        String oldValue = this.getValue();
        if (oldValue != null && oldValue.length() > 0) {
            if (ajaxified) {
                ((WebElement)PrimeSelenium.guardAjax((Object)this.getInput())).clear();
            } else {
                this.getInput().clear();
            }
        }
        ComponentUtils.sendKeys(this.getInput(), value.toString());
        if (ajaxified) {
            ((WebElement)PrimeSelenium.guardAjax((Object)this.getInput())).sendKeys(new CharSequence[]{Keys.TAB});
        } else {
            this.getInput().sendKeys(new CharSequence[]{Keys.TAB});
        }
    }
}

