/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component.base;

import org.json.JSONObject;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.WebElement;
import org.primefaces.selenium.AbstractPrimePageFragment;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.ComponentUtils;

public abstract class AbstractComponent
extends AbstractPrimePageFragment {
    public String getWidgetByIdScript() {
        return ComponentUtils.getWidgetByIdScript(this.getId());
    }

    public String getWidgetConfigurationAsString() {
        return ComponentUtils.getWidgetConfiguration(this.getRoot());
    }

    public JSONObject getWidgetConfiguration() {
        String cfg = this.getWidgetConfigurationAsString();
        if (cfg == null || cfg.length() == 0) {
            return null;
        }
        return new JSONObject(cfg);
    }

    protected boolean isAjaxified(String event) {
        return this.isAjaxified(this.getRoot(), event);
    }

    protected boolean isAjaxified(WebElement element, String event) {
        if (element == null) {
            element = this.getRoot();
        }
        Boolean hasCspRegisteredEvent = false;
        try {
            hasCspRegisteredEvent = (Boolean)PrimeSelenium.executeScript((String)("return PrimeFaces.csp.hasRegisteredAjaxifiedEvent('" + element.getAttribute("id") + "', '" + event + "')"), (Object[])new Object[0]);
        }
        catch (JavascriptException ex) {
            if (ex.getMessage().contains("PrimeFaces.csp.hasRegisteredAjaxifiedEvent is not a function")) {
                System.err.println("WARNING: 'pfselenium.core.csp.js' missing - not added to the page");
            }
            throw ex;
        }
        return ComponentUtils.isAjaxScript(element.getAttribute(event)) || hasCspRegisteredEvent != false;
    }
}

