/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.cli.migration;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import picocli.CommandLine;

public abstract class AbstractPrimeMigration
implements Runnable {
    @CommandLine.Parameters(description={"Directory (including subdirectories) where files with specified fileextension(s) should be migrated."})
    protected String directory;
    @CommandLine.Option(names={"-e", "--fileextension"}, defaultValue="xhtml", split=",", description={"Whitelist of fileextensions of files in the specified directory which should be converted."})
    protected String[] fileextensions = new String[]{"xhtml"};
    @CommandLine.Option(names={"-r", "--replaceexisting"}, defaultValue="true", description={"Replace existing files with converted ones? False means the migrated files are written with additional migrated-suffix."})
    protected Boolean replaceExisting = true;
    protected final Map<String, String> replaceRegex = new LinkedHashMap<String, String>();

    @Override
    public void run() {
        HashSet<String> fileextensionsSet = new HashSet<String>(Arrays.asList(this.fileextensions));
        this.initReplaceRegEx();
        try {
            System.out.println("Start migrating " + this.directory + " and subdirectories; fileextension: " + fileextensionsSet.stream().collect(Collectors.joining(",")) + "; replaceExisting: " + this.replaceExisting);
            this.migrateDirectory(Paths.get(this.directory, new String[0]), fileextensionsSet, this.replaceExisting);
            System.out.println("Finished migration!");
        }
        catch (Exception ex) {
            System.err.println("Error during migration: " + ex.toString());
        }
    }

    protected abstract void initReplaceRegEx();

    public String migrateSource(String source) {
        String result = source;
        for (Map.Entry<String, String> entry : this.replaceRegex.entrySet()) {
            String rOld = entry.getKey();
            String rNew = entry.getValue();
            result = result.replaceAll(rOld, rNew);
        }
        return result;
    }

    protected void migrateDirectory(Path directory, Set<String> fileextensions, boolean replaceExisting) throws Exception {
        Files.list(directory).forEach(f -> {
            block7: {
                try {
                    if (Files.isDirectory(f, new LinkOption[0])) {
                        this.migrateDirectory((Path)f, fileextensions, replaceExisting);
                        break block7;
                    }
                    if (!Files.isRegularFile(f, new LinkOption[0]) || !Files.isWritable(f)) break block7;
                    try {
                        boolean migrateFile = false;
                        String filenameLC = f.toString().toLowerCase();
                        for (String fileextension : fileextensions) {
                            if (!filenameLC.endsWith("." + fileextension)) continue;
                            migrateFile = true;
                        }
                        if (migrateFile) {
                            this.migrateFile((Path)f, replaceExisting);
                        }
                    }
                    catch (Exception ex) {
                        System.err.println("...error during migrating " + f.toString() + ":" + ex.toString());
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
    }

    protected void migrateFile(Path f, boolean replaceExisting) throws IOException {
        List<String> contentV2 = Files.readAllLines(f);
        List contentV3 = contentV2.stream().map(l -> this.migrateSource((String)l)).collect(Collectors.toList());
        Path tmpFile = Paths.get(f.toString() + ".migrated", new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(tmpFile, StandardOpenOption.CREATE);){
            int line = 0;
            for (String l2 : contentV3) {
                if (line > 0) {
                    writer.newLine();
                }
                writer.write(l2);
                ++line;
            }
            writer.newLine();
        }
        if (replaceExisting) {
            Files.delete(f);
            Files.move(tmpFile, f, new CopyOption[0]);
            System.out.println("...migrated " + f.toString());
        } else {
            System.out.println("...migrated " + f.toString() + " to " + tmpFile.toString());
        }
    }
}

