
/*
 * Copyright (c) 2011-2022 PrimeFaces Extensions
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

package org.primefaces.extensions.model.monacoeditor;

import org.primefaces.shaded.json.*;
import java.io.ObjectStreamException;
import java.io.Serializable;

// ============================================================
// THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT DIRECTLY.
// ============================================================

/**
 * Defines how to style a certain token in the Monaco code editor.
 */
@SuppressWarnings("serial")
public class EditorTokenThemeRule extends JSONObject implements Serializable {
    private Object writeReplace() throws ObjectStreamException {
        return new SerializedEditorTokenThemeRule(this);
    }

    private static class SerializedEditorTokenThemeRule implements Serializable {
        private String json;

        public SerializedEditorTokenThemeRule(EditorTokenThemeRule editorTokenThemeRule) {
            this.json = editorTokenThemeRule.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            final EditorTokenThemeRule editorTokenThemeRule = new EditorTokenThemeRule();
            final JSONObject data = new JSONObject(json);
            for (final String key : data.keySet()) {
                final Object value = data.get(key);
                editorTokenThemeRule.put(key, value);
            }
            return editorTokenThemeRule;
        }
    }

    /**
     * @return CSS color for the background that is applied to these tokens.
     */
    public String getBackground() {
        return (String) (has("background") ? get("background") : null);
    }

    /**
     * @param background CSS color for the background that is applied to these tokens.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorTokenThemeRule setBackground(final String background) {
        put("background", background);
        return this;
    }

    /**
     * @return Value for the CSS font-style property that is applied to these tokens.
     */
    public String getFontStyle() {
        return (String) (has("fontStyle") ? get("fontStyle") : null);
    }

    /**
     * @param fontStyle Value for the CSS font-style property that is applied to these tokens.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorTokenThemeRule setFontStyle(final String fontStyle) {
        put("fontStyle", fontStyle);
        return this;
    }

    /**
     * @return CSS color for the text color that is applied to these tokens.
     */
    public String getForeground() {
        return (String) (has("foreground") ? get("foreground") : null);
    }

    /**
     * @param foreground CSS color for the text color that is applied to these tokens.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorTokenThemeRule setForeground(final String foreground) {
        put("foreground", foreground);
        return this;
    }

    /**
     * @return Type of token to which to apply these rules. Can be suffixed with the language ID to which they should
     * apply. E.g. {@code comment} would apply to comment tokens of all languages, {@code comment.js} would only apply
     * to JavaScript comment tokens. You can inspect the tokens in the Monaco editor. Right click on the editor and
     * choose {@code Command Palette}. Then search for {@code Developer: Inspect Tokens}.
     */
    public String getToken() {
        return (String) (has("token") ? get("token") : null);
    }

    /**
     * @param token Type of token to which to apply these rules. Can be suffixed with the language ID to which they
     * should apply. E.g. {@code comment} would apply to comment tokens of all languages, {@code comment.js} would only
     * apply to JavaScript comment tokens. You can inspect the tokens in the Monaco editor. Right click on the editor
     * and choose {@code Command Palette}. Then search for {@code Developer: Inspect Tokens}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorTokenThemeRule setToken(final String token) {
        put("token", token);
        return this;
    }

    /**
     * @return This options object as a serializable JSON object
     */
    JSONObject getJSONObject() {
        return this;
    }
}