/*
 * Copyright (c) 2011-2022 PrimeFaces Extensions
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

package org.primefaces.extensions.model.monacoeditor;

// ============================================================
// THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT DIRECTLY.
// ============================================================

/**
 * rol the cursor style, either {@code block} or {@code line}. Defaults to {@code line}.
 */
public enum ECursorStyle {
    BLOCK("block"),

    LINE("line"),

    UNDERLINE("underline"),

    LINE_THIN("line-thin"),

    BLOCK_OUTLINE("block-outline"),

    UNDERLINE_THIN("underline-thin"),
    ;

    private final String toString;

    ECursorStyle(final String toString) {
        this.toString = toString;
    }

    @Override
    public String toString() {
        return toString;
    }

    public static ECursorStyle parseString(String name) {
        for (final ECursorStyle enumConst : values()) {
            if (enumConst.toString.equals(name)) {
                return enumConst;
            }
        }
        throw new IllegalArgumentException("No such enum constant with name '" + name + "'");
    }
}