/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.primefaces.extensions.converter.JsonConverter;
import org.primefaces.extensions.converter.JsonExposeAwareConverter;

public class RequestParameterBuilder {
    private StringBuilder buffer;
    private final String originalUrl;
    private final JsonConverter jsonConverter;
    private String encoding;
    private boolean added;

    public RequestParameterBuilder() {
        this(null);
    }

    public RequestParameterBuilder(boolean useCurrentRequest) {
        this(useCurrentRequest ? ((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).getRequestURL().toString() : null);
    }

    public RequestParameterBuilder(String url) {
        this(url, null);
    }

    public RequestParameterBuilder(String url, JsonConverter jsonConverter) {
        this.buffer = new StringBuilder(url != null ? url : "");
        this.originalUrl = url != null ? url : "";
        this.jsonConverter = jsonConverter == null ? new JsonExposeAwareConverter(false) : jsonConverter;
        this.encoding = FacesContext.getCurrentInstance().getExternalContext().getRequestCharacterEncoding();
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
    }

    public RequestParameterBuilder paramJson(String name, Object value) throws UnsupportedEncodingException {
        return this.paramJson(name, value, null);
    }

    public RequestParameterBuilder paramJson(String name, Object value, String type) throws UnsupportedEncodingException {
        String encodedJsonValue = this.encodeJson(value, type);
        if (this.added || this.originalUrl.contains("?")) {
            this.buffer.append("&");
        } else {
            this.buffer.append("?");
        }
        this.buffer.append(name);
        this.buffer.append("=");
        this.buffer.append(encodedJsonValue);
        this.added = true;
        return this;
    }

    public RequestParameterBuilder param(String name, Object value) throws UnsupportedEncodingException {
        String encodedValue = this.encode(value);
        if (encodedValue == null) {
            return this;
        }
        if (this.added || this.originalUrl.contains("?")) {
            this.buffer.append("&");
        } else {
            this.buffer.append("?");
        }
        this.buffer.append(name);
        this.buffer.append("=");
        this.buffer.append(encodedValue);
        this.added = true;
        return this;
    }

    public String encode(Object value) throws UnsupportedEncodingException {
        if (value == null) {
            return null;
        }
        return URLEncoder.encode(value.toString(), this.encoding);
    }

    public String encodeJson(Object value, String type) throws UnsupportedEncodingException {
        this.jsonConverter.setType(type);
        String jsonValue = value == null ? "null" : this.jsonConverter.getAsString(null, null, value);
        return URLEncoder.encode(jsonValue, this.encoding);
    }

    public String encodeJson(Object value) throws UnsupportedEncodingException {
        return this.encodeJson(value, null);
    }

    public String build() {
        return this.buffer.toString();
    }

    public RequestParameterBuilder reset() {
        this.buffer = new StringBuilder(this.originalUrl);
        this.jsonConverter.setType(null);
        this.added = false;
        return this;
    }
}

