/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.parameters;

import java.util.Arrays;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;

public class MethodSignatureTagHandler
extends TagHandler {
    public static final String PARAMETERS_TYPES_ATTRIBUTE_NAME = "METHOD_SIGNATURE_PARAMETER_TYPES";
    private final Class<?>[] parameterTypes;

    public MethodSignatureTagHandler(TagConfig config) {
        super(config);
        TagAttribute parametersTag = this.getRequiredAttribute("parameters");
        try {
            this.parameterTypes = this.parseParameterTypes(parametersTag.getValue());
        }
        catch (ClassNotFoundException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) {
        parent.getAttributes().put(PARAMETERS_TYPES_ATTRIBUTE_NAME, this.parameterTypes);
    }

    public Class<?>[] getParameterTypes() {
        if (this.parameterTypes != null) {
            return Arrays.copyOf(this.parameterTypes, this.parameterTypes.length);
        }
        return new Class[0];
    }

    private Class<?>[] parseParameterTypes(String parameters) throws ClassNotFoundException {
        String[] splitParameters = parameters.split(",");
        Class[] types = new Class[splitParameters.length];
        for (int i = 0; i < splitParameters.length; ++i) {
            types[i] = Class.forName(splitParameters[i].trim());
        }
        return types;
    }
}

