/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.osmap;

import java.util.Collection;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.event.map.MarkerDragEvent;
import org.primefaces.event.map.OverlaySelectEvent;
import org.primefaces.event.map.PointSelectEvent;
import org.primefaces.event.map.StateChangeEvent;
import org.primefaces.extensions.component.osmap.OSMapBase;
import org.primefaces.model.map.LatLng;
import org.primefaces.model.map.LatLngBounds;
import org.primefaces.model.map.Marker;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces-extensions", name="leaflet/leaflet.css"), @ResourceDependency(library="primefaces-extensions", name="leaflet/leaflet.js"), @ResourceDependency(library="primefaces-extensions", name="osmap/osmap.js"), @ResourceDependency(library="primefaces-extensions", name="primefaces-extensions.js")})
public class OSMap
extends OSMapBase {
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.OSMap";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put((Object)"overlaySelect", OverlaySelectEvent.class).put((Object)"overlayDblSelect", OverlaySelectEvent.class).put((Object)"stateChange", StateChangeEvent.class).put((Object)"pointSelect", PointSelectEvent.class).put((Object)"pointDblSelect", PointSelectEvent.class).put((Object)"markerDrag", MarkerDragEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        Map params = context.getExternalContext().getRequestParameterMap();
        String eventName = (String)params.get("javax.faces.behavior.event");
        String clientId = this.getClientId(context);
        if (ComponentUtils.isRequestSource((UIComponent)this, (FacesContext)context)) {
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            OverlaySelectEvent wrapperEvent = null;
            if ("overlaySelect".equals(eventName) || "overlayDblSelect".equals(eventName)) {
                wrapperEvent = new OverlaySelectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getModel().findOverlay((String)params.get(clientId + "_overlayId")));
            } else if ("stateChange".equals(eventName)) {
                String[] centerLoc = ((String)params.get(clientId + "_center")).split(",");
                String[] northeastLoc = ((String)params.get(clientId + "_northeast")).split(",");
                String[] southwestLoc = ((String)params.get(clientId + "_southwest")).split(",");
                int zoomLevel = Integer.parseInt((String)params.get(clientId + "_zoom"));
                LatLng center = new LatLng(Double.parseDouble(centerLoc[0]), Double.parseDouble(centerLoc[1]));
                LatLng northeast = new LatLng(Double.parseDouble(northeastLoc[0]), Double.parseDouble(northeastLoc[1]));
                LatLng southwest = new LatLng(Double.parseDouble(southwestLoc[0]), Double.parseDouble(southwestLoc[1]));
                wrapperEvent = new StateChangeEvent((UIComponent)this, behaviorEvent.getBehavior(), new LatLngBounds(northeast, southwest), zoomLevel, center);
            } else if ("pointSelect".equals(eventName) || "pointDblSelect".equals(eventName)) {
                String[] latlng = ((String)params.get(clientId + "_pointLatLng")).split(",");
                LatLng position = new LatLng(Double.parseDouble(latlng[0]), Double.parseDouble(latlng[1]));
                wrapperEvent = new PointSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), position);
            } else if ("markerDrag".equals(eventName)) {
                Marker marker = (Marker)this.getModel().findOverlay((String)params.get(clientId + "_markerId"));
                double lat = Double.parseDouble((String)params.get(clientId + "_lat"));
                double lng = Double.parseDouble((String)params.get(clientId + "_lng"));
                marker.setLatlng(new LatLng(lat, lng));
                wrapperEvent = new MarkerDragEvent((UIComponent)this, behaviorEvent.getBehavior(), marker);
            }
            if (wrapperEvent == null) {
                throw new FacesException("Component " + ((Object)((Object)this)).getClass().getName() + " does not support event " + eventName + "!");
            }
            wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            super.queueEvent((FacesEvent)wrapperEvent);
        } else {
            super.queueEvent(event);
        }
    }
}

