/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.documentviewer;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import javax.el.ValueExpression;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.extensions.component.documentviewer.DocumentViewer;
import org.primefaces.extensions.util.ExtLangUtils;
import org.primefaces.model.StreamedContent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.Callbacks;
import org.primefaces.util.DynamicContentSrcBuilder;
import org.primefaces.util.LangUtils;
import org.primefaces.util.Lazy;

public class DocumentViewerRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        boolean hideResourceVersion = PrimeRequestContext.getCurrentInstance((FacesContext)context).isHideResourceVersion();
        if (hideResourceVersion) {
            this.logDevelopmentWarning(context, "DocumentViewer requires a resource version to work properly and 'primefaces.HIDE_RESOURCE_VERSION' is currently configured.");
        }
        DocumentViewer documentViewer = (DocumentViewer)component;
        this.encodeMarkup(context, documentViewer);
    }

    private void encodeMarkup(FacesContext context, DocumentViewer documentViewer) throws IOException {
        String title = documentViewer.getTitle() != null ? documentViewer.getTitle() : documentViewer.getName();
        title = ExtLangUtils.defaultString(title, "Document Viewer");
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("iframe", (UIComponent)documentViewer);
        writer.writeAttribute("id", (Object)documentViewer.getClientId(), null);
        writer.writeAttribute("style", (Object)documentViewer.getStyle(), null);
        writer.writeAttribute("title", (Object)title, null);
        writer.writeAttribute("width", (Object)(documentViewer.getWidth() != null ? documentViewer.getWidth() : "100%"), null);
        writer.writeAttribute("height", (Object)documentViewer.getHeight(), null);
        writer.writeAttribute("allowfullscreen", (Object)"", null);
        writer.writeAttribute("webkitallowfullscreen", (Object)"", null);
        writer.writeAttribute("src", (Object)this.generateSrc(context, documentViewer), null);
        writer.endElement("iframe");
    }

    private String generateSrc(FacesContext context, DocumentViewer documentViewer) throws IOException {
        String imageSrc;
        try {
            imageSrc = URLEncoder.encode(this.getDocumentSource(context, documentViewer), StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return this.getResourceURL(context) + "&file=" + imageSrc + this.generateHashString(documentViewer);
    }

    private String generateHashString(DocumentViewer documentViewer) {
        ArrayList<CallSite> params = new ArrayList<CallSite>(4);
        params.add((CallSite)((Object)("locale=" + documentViewer.calculateLocale().toString().replace('_', '-'))));
        if (documentViewer.getPage() != null) {
            params.add((CallSite)((Object)("page=" + documentViewer.getPage())));
        }
        if (LangUtils.isNotBlank((String)documentViewer.getZoom())) {
            params.add((CallSite)((Object)("zoom=" + documentViewer.getZoom())));
        }
        if (LangUtils.isNotBlank((String)documentViewer.getNameddest())) {
            params.add((CallSite)((Object)("nameddest=" + documentViewer.getNameddest())));
        }
        if (LangUtils.isNotBlank((String)documentViewer.getPagemode())) {
            params.add((CallSite)((Object)("pagemode=" + documentViewer.getPagemode())));
        }
        params.add((CallSite)((Object)("disableFontFace=" + documentViewer.isDisableFontFace())));
        return "#" + String.join((CharSequence)"&", params.toArray(new String[0]));
    }

    private String getResourceURL(FacesContext context) {
        ResourceHandler handler = context.getApplication().getResourceHandler();
        return context.getExternalContext().encodeResourceURL(handler.createResource("documentviewer/pdfviewer.html", "primefaces-extensions").getRequestPath());
    }

    protected String getDocumentSource(FacesContext context, DocumentViewer documentViewer) {
        String name = documentViewer.getName();
        if (name != null) {
            String libName = documentViewer.getLibrary();
            ResourceHandler handler = context.getApplication().getResourceHandler();
            Resource res = handler.createResource(name, libName);
            if (res == null) {
                return "RES_NOT_FOUND";
            }
            String requestPath = res.getRequestPath();
            return context.getExternalContext().encodeResourceURL(requestPath);
        }
        Object value = documentViewer.getValue();
        String downloadName = documentViewer.getDownload();
        if (value instanceof StreamedContent) {
            StreamedContent streamedContent = (StreamedContent)value;
            downloadName = Objects.toString(streamedContent.getName(), downloadName);
        }
        return DynamicContentSrcBuilder.build((FacesContext)context, (UIComponent)documentViewer, (ValueExpression)documentViewer.getValueExpression("value"), (Lazy)new Lazy((Callbacks.SerializableSupplier & Serializable)() -> value), (boolean)documentViewer.isCache(), (boolean)true) + "&download=" + downloadName;
    }
}

