/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.officecomplexcustomer.appliances;

import java.util.Properties;
import java.util.Vector;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.officecomplexcustomer.appliances.FullyShiftingAppliance;

public class CoffeeMachine
extends FullyShiftingAppliance {
    int standByPower;

    @Override
    public void initialize(String office, Properties conf, int seed) {
        this.name = office + " CoffeeMachine";
        this.saturation = Double.parseDouble(conf.getProperty("RefrigeratorSaturation"));
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.gen = this.randomSeedRepo.getRandomSeed(this.toString(), (long)seed, "Appliance Model" + seed);
        this.power = (int)(23.0 * this.gen.nextGaussian() + 100.0);
        this.cycleDuration = 4;
        this.standByPower = this.power / (this.cycleDuration - 1);
    }

    @Override
    Vector<Boolean> createDailyPossibilityOperationVector(int day) {
        Vector<Boolean> possibilityDailyOperation = new Vector<Boolean>();
        for (int j = 0; j < 96; ++j) {
            if (this.applianceOf.isWorking(day, j)) {
                possibilityDailyOperation.add(true);
                continue;
            }
            possibilityDailyOperation.add(false);
        }
        return possibilityDailyOperation;
    }

    @Override
    public void fillDailyOperation(int weekday) {
        int i;
        this.loadVector = new Vector();
        this.dailyOperation = new Vector();
        int k = this.gen.nextInt(this.cycleDuration);
        for (i = 0; i < 96; ++i) {
            this.loadVector.add(0);
            this.dailyOperation.add(false);
        }
        if (this.applianceOf.isWorkingDayOfWeek(weekday)) {
            for (i = 32; i < 72; ++i) {
                if (i % this.cycleDuration == k) {
                    this.loadVector.set(i, this.power);
                    this.dailyOperation.set(i, true);
                    continue;
                }
                this.loadVector.set(i, this.standByPower);
                this.dailyOperation.set(i, true);
            }
        }
        this.weeklyLoadVector.add(this.loadVector);
        this.weeklyOperation.add(this.dailyOperation);
    }

    @Override
    public void refresh() {
        this.fillWeeklyOperation();
        this.createWeeklyPossibilityOperationVector();
    }
}

