/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.agent;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import org.powermock.core.agent.JavaAgentClassRegister;
import org.powermock.core.transformers.TransformStrategy;
import org.powermock.core.transformers.impl.ClassMockTransformer;
import org.powermock.core.transformers.impl.InterfaceMockTransformer;
import org.powermock.modules.agent.AbstractClassTransformer;

class PowerMockClassTransformer
extends AbstractClassTransformer
implements ClassFileTransformer {
    private volatile Set<String> classesToTransform;
    private volatile JavaAgentClassRegister javaAgentClassRegister;
    private static final ClassMockTransformer CLASS_MOCK_TRANSFORMER = new ClassMockTransformer(TransformStrategy.INST_REDEFINE);
    private static final InterfaceMockTransformer INTERFACE_MOCK_TRANSFORMER = new InterfaceMockTransformer(TransformStrategy.INST_REDEFINE);

    PowerMockClassTransformer() {
    }

    public void setClassesToTransform(Collection<String> classesToTransform) {
        this.classesToTransform = new HashSet<String>(classesToTransform);
    }

    public void setJavaAgentClassRegister(JavaAgentClassRegister javaAgentClassRegister) {
        this.javaAgentClassRegister = javaAgentClassRegister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (loader == null || this.shouldIgnore(className)) {
            return null;
        }
        try {
            String normalizedClassName = className.replace("/", ".");
            if (this.classesToTransform != null && this.classesToTransform.contains(normalizedClassName)) {
                ByteArrayInputStream is = new ByteArrayInputStream(classfileBuffer);
                CtClass ctClass = null;
                try {
                    ctClass = ClassPool.getDefault().makeClass((InputStream)is);
                }
                finally {
                    is.close();
                }
                ctClass = ctClass.isInterface() ? INTERFACE_MOCK_TRANSFORMER.transform(ctClass) : CLASS_MOCK_TRANSFORMER.transform(ctClass);
                ctClass.detach();
                this.javaAgentClassRegister.registerClass(loader, normalizedClassName);
                return ctClass.toBytecode();
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to redefine class " + className, e);
        }
    }
}

