/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.agent;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import org.powermock.core.transformers.TransformStrategy;
import org.powermock.core.transformers.impl.MainMockTransformer;
import org.powermock.modules.agent.AbstractClassTransformer;

class PowerMockClassTransformer
extends AbstractClassTransformer
implements ClassFileTransformer {
    private volatile Set<String> classesToTransform;
    private static final MainMockTransformer mainMockTransformer = new MainMockTransformer(TransformStrategy.INST_REDEFINE);

    PowerMockClassTransformer() {
    }

    public void setClassesToTransform(Collection<String> classesToTransform) {
        this.classesToTransform = new HashSet<String>(classesToTransform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (loader == null || this.shouldIgnore(className)) {
            return null;
        }
        try {
            if (this.classesToTransform != null && this.classesToTransform.contains(className.replace("/", "."))) {
                ByteArrayInputStream is = new ByteArrayInputStream(classfileBuffer);
                CtClass ctClass = null;
                try {
                    ctClass = ClassPool.getDefault().makeClass((InputStream)is);
                }
                finally {
                    is.close();
                }
                ctClass = mainMockTransformer.transform(ctClass);
                ctClass.detach();
                return ctClass.toBytecode();
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to redefine class " + className, e);
        }
    }
}

