/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.BuiltinCodecSupport;
import io.r2dbc.postgresql.codec.EpochTime;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlDateTimeFormatter;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.codec.PostgresqlTimeFormatter;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.temporal.Temporal;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;

abstract class AbstractTemporalCodec<T extends Temporal>
extends BuiltinCodecSupport<T> {
    private static final Set<PostgresqlObjectId> SUPPORTED_TYPES = EnumSet.of(PostgresqlObjectId.DATE, PostgresqlObjectId.TIMESTAMP, PostgresqlObjectId.TIMESTAMPTZ, PostgresqlObjectId.TIME, PostgresqlObjectId.TIMETZ);
    private final PostgresqlObjectId postgresType;

    AbstractTemporalCodec(Class<T> type, ByteBufAllocator byteBufAllocator, PostgresqlObjectId postgresType, PostgresqlObjectId postgresArrayType, Function<T, String> toTextEncoder) {
        super(type, byteBufAllocator, postgresType, postgresArrayType, toTextEncoder);
        this.postgresType = postgresType;
    }

    @Override
    public boolean canDecode(int dataType, Format format, Class<?> type) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        if (type == Object.class && PostgresqlObjectId.isValid(dataType) && PostgresqlObjectId.valueOf(dataType) != this.getDefaultType()) {
            return false;
        }
        return super.canDecode(dataType, format, type);
    }

    @Override
    final boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return SUPPORTED_TYPES.contains(type);
    }

    T decodeTemporal(ByteBuf buffer, PostgresTypeIdentifier dataType, @Nullable Format format, Class<T> expectedType, Function<Temporal, T> converter) {
        Temporal number = this.decodeTemporal(buffer, PostgresqlObjectId.from(dataType), format);
        return (T)((Temporal)AbstractTemporalCodec.potentiallyConvert(number, expectedType, converter));
    }

    private Temporal decodeTemporal(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        switch (dataType) {
            case TIMESTAMP: 
            case TIMESTAMP_ARRAY: {
                if (Format.FORMAT_BINARY == format) {
                    return EpochTime.fromLong(buffer.readLong()).toLocalDateTime();
                }
                return PostgresqlDateTimeFormatter.parseLocalDateTime(ByteBufUtils.decode(buffer));
            }
            case DATE: 
            case DATE_ARRAY: {
                if (Format.FORMAT_BINARY == format) {
                    return LocalDate.ofEpochDay(EpochTime.fromInt(buffer.readInt()).getJavaDays());
                }
                return PostgresqlDateTimeFormatter.parseLocalDate(ByteBufUtils.decode(buffer));
            }
            case TIME: 
            case TIME_ARRAY: {
                if (Format.FORMAT_BINARY == format) {
                    return LocalTime.ofNanoOfDay(buffer.readLong() * 1000L);
                }
                return PostgresqlTimeFormatter.parseLocalTime(ByteBufUtils.decode(buffer));
            }
            case TIMESTAMPTZ: 
            case TIMESTAMPTZ_ARRAY: {
                if (Format.FORMAT_BINARY == format) {
                    return EpochTime.fromLong(buffer.readLong()).toInstant().atOffset(OffsetDateTime.now().getOffset());
                }
                return PostgresqlDateTimeFormatter.parseOffsetDateTime(ByteBufUtils.decode(buffer));
            }
            case TIMETZ: 
            case TIMETZ_ARRAY: {
                if (Format.FORMAT_BINARY == format) {
                    long timeNano = buffer.readLong() * 1000L;
                    int offsetSec = -buffer.readInt();
                    return OffsetTime.of(LocalTime.ofNanoOfDay(timeNano), ZoneOffset.ofTotalSeconds(offsetSec));
                }
                return PostgresqlTimeFormatter.parseOffsetTime(ByteBufUtils.decode(buffer));
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot decode value for type %s, format %s", new Object[]{dataType, format}));
    }

    @Nullable PostgresqlObjectId getDefaultType() {
        return this.postgresType;
    }

    static <T> T potentiallyConvert(Temporal temporal, Class<T> expectedType, Function<Temporal, T> converter) {
        return expectedType.isInstance(temporal) ? expectedType.cast(temporal) : converter.apply(temporal);
    }
}

