/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.ArrayCodecDelegate;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.codec.PrimitiveCodec;
import io.r2dbc.postgresql.codec.PrimitiveWrapperCodecProvider;
import io.r2dbc.postgresql.codec.ShortCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import reactor.util.annotation.Nullable;

final class ByteCodec
extends AbstractCodec<Byte>
implements ArrayCodecDelegate<Byte>,
PrimitiveWrapperCodecProvider<Byte> {
    private final ShortCodec delegate;

    ByteCodec(ByteBufAllocator byteBufAllocator) {
        super(Byte.class);
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        this.delegate = new ShortCodec(byteBufAllocator);
    }

    @Override
    public PrimitiveCodec<Byte> getPrimitiveCodec() {
        return new PrimitiveCodec<Byte>(Byte.TYPE, Byte.class, this);
    }

    @Override
    public EncodedParameter encodeNull() {
        return this.delegate.encodeNull();
    }

    @Override
    public boolean canDecode(int dataType, Format format, Class<?> type) {
        return super.canDecode(dataType, format, type) && this.delegate.canDecode(dataType, format, Short.class);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(type, "type must not be null");
        return this.delegate.doCanDecode(type, format);
    }

    @Override
    Byte doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, Format format, @Nullable Class<? extends Byte> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        Assert.requireNonNull(format, "format must not be null");
        return ((Short)this.delegate.doDecode(buffer, dataType, format, Short.class)).byteValue();
    }

    @Override
    EncodedParameter doEncode(Byte value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.delegate.doEncode(Short.valueOf(value.byteValue()));
    }

    @Override
    EncodedParameter doEncode(Byte value, PostgresTypeIdentifier dataType) {
        return this.delegate.doEncode(Short.valueOf(value.byteValue()), dataType);
    }

    @Override
    public String encodeToText(Byte value) {
        Assert.requireNonNull(value, "value must not be null");
        return value.toString();
    }

    @Override
    public PostgresTypeIdentifier getArrayDataType() {
        return PostgresqlObjectId.INT2_ARRAY;
    }

    @Override
    public Iterable<Format> getFormats() {
        return this.delegate.getFormats();
    }

    @Override
    public Iterable<PostgresTypeIdentifier> getDataTypes() {
        return this.delegate.getDataTypes();
    }
}

