/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.r2dbc.postgresql.client.ConnectionContext;
import java.util.Objects;
import reactor.util.Logger;
import reactor.util.Loggers;

final class BindingLogger {
    private static final Logger BINDING_LOGGER = Loggers.getLogger((String)"io.r2dbc.postgresql.PARAM");
    private static final boolean LOGGING_ENABLED = BINDING_LOGGER.isDebugEnabled();

    BindingLogger() {
    }

    static void logBind(ConnectionContext connectionContext, int index, Object bindValue) {
        if (LOGGING_ENABLED) {
            BINDING_LOGGER.debug(connectionContext.getMessage("Bind parameter [{}] to: {}"), new Object[]{index, Objects.toString(bindValue)});
        }
    }

    static void logBind(ConnectionContext connectionContext, String name, Object bindValue) {
        if (LOGGING_ENABLED) {
            BINDING_LOGGER.debug(connectionContext.getMessage("Bind parameter [{}] to: {}"), new Object[]{name, Objects.toString(bindValue)});
        }
    }

    static void logBindNull(ConnectionContext connectionContext, int index, Class<?> type) {
        if (LOGGING_ENABLED) {
            BINDING_LOGGER.debug(connectionContext.getMessage("Bind parameter [{}] to null, type: {}"), new Object[]{index, type.getName()});
        }
    }

    static void logBindNull(ConnectionContext connectionContext, String name, Class<?> type) {
        if (LOGGING_ENABLED) {
            BINDING_LOGGER.debug(connectionContext.getMessage("Bind parameter [{}] to null, type: {}"), new Object[]{name, type.getName()});
        }
    }
}

