/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.AbstractTemporalCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import reactor.util.annotation.Nullable;

final class InstantCodec
extends AbstractTemporalCodec<Instant> {
    InstantCodec(ByteBufAllocator byteBufAllocator) {
        super(Instant.class, byteBufAllocator, PostgresqlObjectId.TIMESTAMPTZ, PostgresqlObjectId.TIMESTAMPTZ_ARRAY, Instant::toString);
    }

    @Override
    Instant doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, @Nullable Format format, Class<? extends Instant> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return this.decodeTemporal(buffer, dataType, format, Instant.class, temporal -> {
            if (temporal instanceof LocalDateTime) {
                return ((LocalDateTime)temporal).toInstant(ZoneOffset.UTC);
            }
            if (temporal instanceof LocalDate) {
                return ((LocalDate)temporal).atStartOfDay(ZoneId.systemDefault()).toInstant();
            }
            return Instant.from(temporal);
        });
    }

    @Override
    PostgresqlObjectId getDefaultType() {
        return null;
    }
}

