/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.ArrayCodecDelegate;
import io.r2dbc.postgresql.codec.LocalDateTimeCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import reactor.util.annotation.Nullable;

final class DateCodec
extends AbstractCodec<Date>
implements ArrayCodecDelegate<Date> {
    private final LocalDateTimeCodec delegate;

    DateCodec(ByteBufAllocator byteBufAllocator) {
        super(Date.class);
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        this.delegate = new LocalDateTimeCodec(byteBufAllocator);
    }

    @Override
    public EncodedParameter encodeNull() {
        return this.delegate.encodeNull();
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return this.delegate.doCanDecode(type, format);
    }

    @Override
    Date doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, @Nullable Format format, @Nullable Class<? extends Date> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        Object intermediary = this.delegate.doDecode(buffer, dataType, format, LocalDateTime.class);
        return Date.from(((LocalDateTime)intermediary).atZone(ZoneId.systemDefault()).toInstant());
    }

    @Override
    EncodedParameter doEncode(Date value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.delegate.doEncode(DateCodec.normalize(value));
    }

    @Override
    EncodedParameter doEncode(Date value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return this.delegate.doEncode(DateCodec.normalize(value), dataType);
    }

    @Override
    public String encodeToText(Date value) {
        Assert.requireNonNull(value, "value must not be null");
        return DateCodec.normalize(value).toString();
    }

    @Override
    public PostgresTypeIdentifier getArrayDataType() {
        return this.delegate.getArrayDataType();
    }

    private static LocalDateTime normalize(Date value) {
        return value.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }
}

