/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.ArrayCodecDelegate;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

class ArrayCodec<T>
extends AbstractCodec<Object[]> {
    private static final byte CLOSE_CURLY = 125;
    private static final byte COMMA = 44;
    private static final String NULL = "NULL";
    private static final byte OPEN_CURLY = 123;
    private final ArrayCodecDelegate<T> delegate;
    private final ByteBufAllocator byteBufAllocator;
    private final Class<T> componentType;
    private final PostgresTypeIdentifier dataType;
    private final byte delimiter;

    ArrayCodec(ByteBufAllocator byteBufAllocator, ArrayCodecDelegate<T> delegate, Class<T> componentType) {
        super(Object[].class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        this.delegate = Assert.requireNonNull(delegate, "delegate must not be null");
        this.dataType = delegate.getArrayDataType();
        this.componentType = Assert.requireNonNull(componentType, "componentType must not be null");
        this.delimiter = (byte)44;
    }

    ArrayCodec(ByteBufAllocator byteBufAllocator, PostgresTypeIdentifier dataType, ArrayCodecDelegate<T> delegate, Class<T> componentType) {
        super(Object[].class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        this.dataType = Assert.requireNonNull(dataType, "dataType must not be null");
        this.delegate = Assert.requireNonNull(delegate, "delegate must not be null");
        this.componentType = Assert.requireNonNull(componentType, "componentType must not be null");
        this.delimiter = (byte)44;
    }

    ArrayCodec(ByteBufAllocator byteBufAllocator, PostgresTypeIdentifier dataType, ArrayCodecDelegate<T> delegate, Class<T> componentType, byte delimiter) {
        super(Object[].class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        this.dataType = Assert.requireNonNull(dataType, "dataType must not be null");
        this.delegate = Assert.requireNonNull(delegate, "delegate must not be null");
        this.componentType = Assert.requireNonNull(componentType, "componentType must not be null");
        this.delimiter = delimiter;
    }

    public ArrayCodecDelegate<T> getDelegate() {
        return this.delegate;
    }

    public Class<T> getComponentType() {
        return this.componentType;
    }

    @Override
    public boolean canEncode(Object value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.isTypeAssignable(value.getClass());
    }

    @Override
    public boolean canEncodeNull(Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        return this.isTypeAssignable(type);
    }

    @Override
    public EncodedParameter encodeNull() {
        return this.encodeNull(this.dataType.getObjectId());
    }

    static String escapeArrayElement(String s) {
        StringBuilder b = new StringBuilder("\"");
        for (int j = 0; j < s.length(); ++j) {
            char c = s.charAt(j);
            if (c == '\"' || c == '\\') {
                b.append('\\');
            }
            b.append(c);
        }
        b.append('\"');
        return b.toString();
    }

    @Override
    Object[] doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, Format format, Class<? extends Object[]> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        if (Format.FORMAT_BINARY == format) {
            return this.decodeBinary(buffer, this.dataType, type);
        }
        return this.decodeText(buffer, this.dataType, type);
    }

    @Override
    public boolean canDecode(int dataType, Format format, Class<?> type) {
        return this.dataType.getObjectId() == dataType && (type == Object.class || type.isArray() && this.getActualComponentType(type).isAssignableFrom(this.componentType));
    }

    Class<?> getActualComponentType(Class<?> requestedType) {
        Class<?> type = requestedType;
        while (type.isArray()) {
            type = type.getComponentType();
        }
        return type;
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(type, "type must not be null");
        return this.dataType.equals(type);
    }

    @Override
    final EncodedParameter doEncode(Object[] value) {
        return this.doEncode(value, this.dataType);
    }

    @Override
    EncodedParameter doEncode(Object[] value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return this.encodeArray(() -> {
            ByteBuf byteBuf = this.byteBufAllocator.buffer();
            this.encodeAsText(byteBuf, value, this.delegate::encodeToText);
            return byteBuf;
        }, dataType);
    }

    EncodedParameter encodeArray(Supplier<ByteBuf> encodedSupplier, PostgresTypeIdentifier dataType) {
        return ArrayCodec.create(Format.FORMAT_TEXT, dataType, encodedSupplier);
    }

    @Override
    boolean isTypeAssignable(Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        return type.isArray() && this.componentType.equals(ArrayCodec.getBaseComponentType(type));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [delegate=").append(this.delegate);
        sb.append(']');
        return sb.toString();
    }

    private static Class<?> getBaseComponentType(Class<?> type) {
        Class<?> t = type;
        while (t.getComponentType() != null) {
            t = t.getComponentType();
        }
        return t;
    }

    private static int getDimensions(List<?> list) {
        int dims = 1;
        Object inner = list.get(0);
        while (inner instanceof List) {
            inner = ((List)inner).get(0);
            ++dims;
        }
        return dims;
    }

    Object[] decodeBinary(ByteBuf buffer, PostgresTypeIdentifier dataType, Class<?> returnType) {
        if (!buffer.isReadable()) {
            return new Object[0];
        }
        int dimensions = buffer.readInt();
        if (dimensions == 0) {
            return (Object[])Array.newInstance(this.componentType, 0);
        }
        if (returnType != Object.class) {
            Assert.requireArrayDimension(returnType, dimensions, "Dimensions mismatch: %s expected, but %s returned from DB");
        }
        buffer.skipBytes(4);
        buffer.skipBytes(4);
        int[] dims = new int[dimensions];
        for (int d = 0; d < dimensions; ++d) {
            dims[d] = buffer.readInt();
            buffer.skipBytes(4);
        }
        Object[] array = (Object[])Array.newInstance(this.componentType, dims);
        this.readArrayAsBinary(buffer, dataType, array, dims, 0);
        return array;
    }

    Object[] decodeText(ByteBuf buffer, PostgresTypeIdentifier dataType, Class<?> returnType) {
        List<Object> elements = this.decodeText(buffer, dataType);
        if (elements.isEmpty()) {
            return (Object[])Array.newInstance(this.componentType, 0);
        }
        int dimensions = ArrayCodec.getDimensions(elements);
        if (returnType != Object.class) {
            Assert.requireArrayDimension(returnType, dimensions, "Dimensions mismatch: %s expected, but %s returned from DB");
        }
        return ArrayCodec.toArray(elements, this.createArrayType(dimensions).getComponentType());
    }

    private Class<?> createArrayType(int dims) {
        int[] size = new int[dims];
        Arrays.fill(size, 1);
        return Array.newInstance(this.componentType, size).getClass();
    }

    private static Object[] toArray(List<?> list, Class<?> returnType) {
        ArrayList result = new ArrayList(list.size());
        for (Object e : list) {
            Object o = e instanceof List ? ArrayCodec.toArray((List)e, returnType.getComponentType()) : e;
            result.add(o);
        }
        return result.toArray((Object[])Array.newInstance(returnType, list.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> decodeText(ByteBuf buf, PostgresTypeIdentifier dataType) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean insideString = false;
        boolean wasInsideString = false;
        ArrayList dims = new ArrayList();
        List<Object> currentArray = arrayList;
        if (buf.isReadable() && buf.getByte(0) == 91) {
            while (buf.readByte() != 61) {
            }
        }
        int indentEscape = 0;
        int readFrom = 0;
        boolean requiresEscapeCharFiltering = false;
        while (buf.isReadable()) {
            byte currentChar = buf.readByte();
            if (currentChar == 92) {
                ++indentEscape;
                buf.skipBytes(1);
                requiresEscapeCharFiltering = true;
                continue;
            }
            if (!insideString && currentChar == 123) {
                if (dims.isEmpty()) {
                    dims.add(arrayList);
                } else {
                    ArrayList a = new ArrayList();
                    List p = (List)dims.get(dims.size() - 1);
                    p.add(a);
                    dims.add(a);
                }
                currentArray = (List)dims.get(dims.size() - 1);
                for (int t = indentEscape + 1; t < buf.writerIndex() && (Character.isWhitespace(buf.getByte(t)) || buf.getByte(t) == 123); ++t) {
                }
                readFrom = buf.readerIndex();
                continue;
            }
            if (currentChar == 34) {
                insideString = !insideString;
                wasInsideString = true;
                continue;
            }
            if (!insideString && Character.isWhitespace(currentChar) || (insideString || currentChar != this.delimiter && currentChar != 125) && indentEscape != buf.writerIndex() - 1) continue;
            int skipTrailingBytes = 0;
            if (currentChar != 125 && currentChar != this.delimiter && readFrom > 0) {
                ++skipTrailingBytes;
            }
            if (wasInsideString) {
                ++readFrom;
                ++skipTrailingBytes;
            }
            ByteBuf slice = buf.slice(readFrom, buf.readerIndex() - readFrom - (skipTrailingBytes + 1));
            try {
                if (requiresEscapeCharFiltering) {
                    ByteBuf filtered = slice.alloc().buffer(slice.readableBytes());
                    while (slice.isReadable()) {
                        byte ch = slice.readByte();
                        if (ch == 92) {
                            ch = slice.readByte();
                        }
                        filtered.writeByte((int)ch);
                    }
                    slice = filtered;
                }
                if (slice.isReadable() || wasInsideString) {
                    if (!wasInsideString && slice.readableBytes() == 4 && slice.getByte(0) == 78 && NULL.equals(slice.toString(StandardCharsets.US_ASCII))) {
                        currentArray.add(null);
                    } else {
                        currentArray.add(this.delegate.decode(slice, dataType, Format.FORMAT_TEXT, this.componentType));
                    }
                }
            }
            finally {
                if (requiresEscapeCharFiltering) {
                    slice.release();
                }
            }
            wasInsideString = false;
            requiresEscapeCharFiltering = false;
            readFrom = buf.readerIndex();
            if (currentChar != 125) continue;
            dims.remove(dims.size() - 1);
            if (dims.isEmpty()) continue;
            currentArray = (List)dims.get(dims.size() - 1);
        }
        return arrayList;
    }

    private void encodeAsText(ByteBuf byteBuf, Object[] value, Function<T, String> encoder) {
        byteBuf.writeByte(123);
        for (int i = 0; i < value.length; ++i) {
            Object item = value[i];
            if (item instanceof Object[]) {
                this.encodeAsText(byteBuf, (Object[])item, encoder);
            } else {
                byteBuf.writeCharSequence(item == null ? NULL : (CharSequence)encoder.apply(item), StandardCharsets.UTF_8);
            }
            if (i == value.length - 1) continue;
            byteBuf.writeByte((int)this.delimiter);
        }
        byteBuf.writeByte(125);
    }

    private void readArrayAsBinary(ByteBuf buffer, PostgresTypeIdentifier dataType, Object[] array, int[] dims, int thisDimension) {
        if (thisDimension == dims.length - 1) {
            for (int i = 0; i < dims[thisDimension]; ++i) {
                int len = buffer.readInt();
                if (len == -1) continue;
                array[i] = this.delegate.decode(buffer.readSlice(len), dataType, Format.FORMAT_BINARY, this.componentType);
            }
        } else {
            for (int i = 0; i < dims[thisDimension]; ++i) {
                this.readArrayAsBinary(buffer, dataType, (Object[])array[i], dims, thisDimension + 1);
            }
        }
    }
}

