/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.ArrayCodecDelegate;
import io.r2dbc.postgresql.codec.NumericDecodeUtils;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import reactor.util.annotation.Nullable;

abstract class AbstractNumericCodec<T extends Number>
extends AbstractCodec<T>
implements ArrayCodecDelegate<T> {
    private static final Set<PostgresqlObjectId> SUPPORTED_TYPES = EnumSet.of(PostgresqlObjectId.INT2, new PostgresqlObjectId[]{PostgresqlObjectId.INT4, PostgresqlObjectId.INT8, PostgresqlObjectId.FLOAT4, PostgresqlObjectId.FLOAT8, PostgresqlObjectId.NUMERIC, PostgresqlObjectId.OID});
    private final ByteBufAllocator byteBufAllocator;

    AbstractNumericCodec(Class<T> type, ByteBufAllocator byteBufAllocator) {
        super(type);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public boolean canDecode(int dataType, Format format, Class<?> type) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        if (type == Object.class && PostgresqlObjectId.isValid(dataType) && PostgresqlObjectId.valueOf(dataType) != this.getDefaultType()) {
            return false;
        }
        return super.canDecode(dataType, format, type);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(type, "type must not be null");
        Assert.requireNonNull(format, "format must not be null");
        return SUPPORTED_TYPES.contains(type);
    }

    @Override
    EncodedParameter doEncode(T value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.doEncode(value, (PostgresTypeIdentifier)this.getDefaultType());
    }

    @Override
    EncodedParameter doEncode(T value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        if (dataType == PostgresqlObjectId.NUMERIC) {
            return AbstractNumericCodec.create(Format.FORMAT_TEXT, dataType, () -> ByteBufUtils.encode(this.byteBufAllocator, value.toString()));
        }
        return AbstractNumericCodec.create(Format.FORMAT_BINARY, dataType, () -> this.doEncodeNumber((Number)value, dataType));
    }

    @Override
    public String encodeToText(T value) {
        Assert.requireNonNull(value, "value must not be null");
        return value.toString();
    }

    private ByteBuf doEncodeNumber(Number value, PostgresTypeIdentifier identifier) {
        PostgresqlObjectId oid = PostgresqlObjectId.valueOf(identifier.getObjectId());
        switch (oid) {
            case FLOAT8: {
                return this.byteBufAllocator.buffer(8).writeDouble(value.doubleValue());
            }
            case FLOAT4: {
                return this.byteBufAllocator.buffer(4).writeFloat(value.floatValue());
            }
            case INT8: {
                return this.byteBufAllocator.buffer(8).writeLong(value.longValue());
            }
            case INT4: {
                return this.byteBufAllocator.buffer(4).writeInt(value.intValue());
            }
            case INT2: {
                return this.byteBufAllocator.buffer(4).writeShort((int)value.shortValue());
            }
        }
        throw new IllegalArgumentException(String.format("Cannot encode %s to %s", value, oid));
    }

    T decodeNumber(ByteBuf buffer, PostgresTypeIdentifier dataType, @Nullable Format format, Class<T> expectedType, Function<Number, T> converter) {
        Number number = NumericDecodeUtils.decodeNumber(buffer, PostgresqlObjectId.from(dataType), format);
        return (T)((Number)AbstractNumericCodec.potentiallyConvert(number, expectedType, converter));
    }

    @Override
    public EncodedParameter encodeNull() {
        return AbstractNumericCodec.createNull(Format.FORMAT_BINARY, this.getDefaultType());
    }

    abstract PostgresqlObjectId getDefaultType();

    private static <T> T potentiallyConvert(Number number, Class<T> expectedType, Function<Number, T> converter) {
        return expectedType.isInstance(number) ? expectedType.cast(number) : converter.apply(number);
    }
}

