/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractArrayCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.util.function.Supplier;

final class ShortArrayCodec
extends AbstractArrayCodec<Short> {
    ShortArrayCodec(ByteBufAllocator byteBufAllocator) {
        super(byteBufAllocator, Short.class, PostgresqlObjectId.INT2_ARRAY);
    }

    @Override
    Short doDecodeBinary(ByteBuf byteBuffer) {
        return byteBuffer.readShort();
    }

    @Override
    Short doDecodeText(String text) {
        return Short.parseShort(text);
    }

    @Override
    EncodedParameter encodeArray(Supplier<ByteBuf> encodedSupplier, PostgresTypeIdentifier dataType) {
        return ShortArrayCodec.create(Format.FORMAT_TEXT, dataType, encodedSupplier);
    }

    @Override
    String doEncodeText(Short value) {
        Assert.requireNonNull(value, "value must not be null");
        return value.toString();
    }
}

