/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.api.PostgresqlResult;
import io.r2dbc.postgresql.api.RefCursor;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

final class RefCursorCodec
extends AbstractCodec<RefCursor> {
    static final RefCursorCodec INSTANCE = new RefCursorCodec();

    RefCursorCodec() {
        super(RefCursor.class);
    }

    @Override
    public EncodedParameter encodeNull() {
        throw new UnsupportedOperationException("RefCursor cannot be encoded");
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.REF_CURSOR == type;
    }

    @Override
    RefCursor doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, @Nullable Class<? extends RefCursor> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return new SimpleRefCursor(ByteBufUtils.decode(buffer));
    }

    @Override
    EncodedParameter doEncode(RefCursor value) {
        throw new UnsupportedOperationException("RefCursor cannot be encoded");
    }

    @Override
    EncodedParameter doEncode(RefCursor value, PostgresTypeIdentifier dataType) {
        throw new UnsupportedOperationException("RefCursor cannot be encoded");
    }

    static class SimpleRefCursor
    implements RefCursor {
        private final String portal;

        SimpleRefCursor(String portal) {
            this.portal = portal;
        }

        @Override
        public String getCursorName() {
            return this.portal;
        }

        @Override
        public Mono<PostgresqlResult> fetch() {
            throw new UnsupportedOperationException("Stateless RefCursor does not support fetch()");
        }

        @Override
        public Mono<Void> close() {
            throw new UnsupportedOperationException("Stateless RefCursor does not support close()");
        }

        public String toString() {
            return "SimpleRefCursor{portal='" + this.portal + '\'' + '}';
        }
    }
}

