/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractTemporalCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import reactor.util.annotation.Nullable;

final class LocalDateTimeCodec
extends AbstractTemporalCodec<LocalDateTime> {
    private final ByteBufAllocator byteBufAllocator;

    LocalDateTimeCodec(ByteBufAllocator byteBufAllocator) {
        super(LocalDateTime.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    LocalDateTime doDecode(ByteBuf buffer, PostgresqlObjectId dataType, @Nullable Format format, @Nullable Class<? extends LocalDateTime> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return this.decodeTemporal(buffer, dataType, format, LocalDateTime.class, temporal -> {
            if (temporal instanceof LocalDate) {
                return ((LocalDate)temporal).atStartOfDay(ZoneId.systemDefault()).toLocalDateTime();
            }
            return Instant.from(temporal).atOffset(ZoneOffset.UTC).toLocalDateTime();
        });
    }

    @Override
    EncodedParameter doEncode(LocalDateTime value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return LocalDateTimeCodec.create(Format.FORMAT_TEXT, dataType, () -> ByteBufUtils.encode(this.byteBufAllocator, value.toString()));
    }

    @Override
    PostgresqlObjectId getDefaultType() {
        return PostgresqlObjectId.TIMESTAMP;
    }
}

