package javadoc331;

import com.sun.javadoc.*;
import com.sun.tools.doclets.Taglet;
import java.util.Map;
import java.util.StringTokenizer;

/** Implements the {@code @spec.specfield} tag for use in method specifications. */
public class SpecfieldTaglet implements Taglet {

  public String getName() {
    return "spec.specfield";
  }

  public String getHeader() {
    return "Specification Fields";
  }

  public boolean inField() {
    return false;
  }

  public boolean inConstructor() {
    return false;
  }

  public boolean inMethod() {
    return false;
  }

  public boolean inOverview() {
    return false;
  }

  public boolean inPackage() {
    return false;
  }

  public boolean inType() {
    return true;
  }

  public boolean isInlineTag() {
    return false;
  }

  /**
   * Register this Taglet.
   *
   * @param tagletMap the map to register this tag to.
   */
  public static void register(Map<String, Taglet> tagletMap) {
    Taglet tag = new SpecfieldTaglet();
    Taglet t = tagletMap.get(tag.getName());
    if (t != null) {
      tagletMap.remove(tag.getName());
    }
    tagletMap.put(tag.getName(), tag);
  }

  /**
   * Format a String as a specfield. Basically pull off the first word and typeset it as a variable
   * name.
   *
   * @param text The text to typeset.
   * @return HTML marked up text.
   */
  protected static String formatText(String text) {
    StringBuffer retval = new StringBuffer();
    StringTokenizer st = new StringTokenizer(text, " \t\n\r", true);
    retval.append("<CODE>");
    retval.append(st.nextToken());
    retval.append("</CODE> - ");
    while (st.hasMoreTokens()) {
      retval.append(st.nextToken());
    }
    return retval.toString();
  }

  /**
   * Given the <code>Tag</code> representation of this custom tag, return its string representation.
   *
   * @param tag the <code>Tag</code> representation of this custom tag.
   */
  public String toString(Tag tag) {
    return "<DT><B>" + this.getHeader() + ":</B><DD>" + formatText(tag.text()) + "</DD>\n";
  }

  /**
   * Given an array of <code>Tag</code>s representing this custom tag, return its string
   * representation.
   *
   * @param tags the array of <code>Tag</code>s representing of this custom tag.
   */
  public String toString(Tag[] tags) {
    if (tags.length == 0) {
      return "";
    } else if (tags.length == 1) {
      return this.toString(tags[0]);
    } else {
      String result = "\n<DT><B>" + this.getHeader() + "</B><DD>";
      result += " <ul>\n";
      for (int i = 0; i < tags.length; i++) {
        result += "  <li> " + formatText(tags[i].text()) + "\n";
      }
      return result + " </ul>\n</DD>\n";
    }
  }
}
