package javadoc331;

import com.sun.javadoc.*;
import com.sun.tools.doclets.Taglet;
import java.util.Map;

/**
 * MethodTaglet is an abstract Taglet for use in javadoc331.
 *
 * <p>Subclasses will be Taglets that can be used to describe methods and constructors.
 */
public abstract class MethodTaglet implements Taglet {

  /**
   * Return the name of this custom tag.
   *
   * @return the name of this custom tag
   */
  public abstract String getName();

  /**
   * Return the header of this tag.
   *
   * @return the header of this tag
   */
  public abstract String getHeader();

  public boolean inField() {
    return false;
  }

  public boolean inConstructor() {
    return true;
  }

  public boolean inMethod() {
    return true;
  }

  public boolean inOverview() {
    return false;
  }

  public boolean inPackage() {
    return false;
  }

  public boolean inType() {
    return false;
  }

  public boolean isInlineTag() {
    return false;
  }

  /**
   * Register this Taglet.
   *
   * @param tagletMap the map to register this tag to.
   */
  public static void register(Map<String, Taglet> tagletMap) {
    throw new UnsupportedOperationException();
  }

  /**
   * Given the <code>Tag</code> representation of this custom tag, return its string representation.
   *
   * @param tag the <code>Tag</code> representation of this custom tag.
   */
  public String toString(Tag tag) {
    return "<DT><B>" + this.getHeader() + "</B><DD>" + tag.text() + "</DD>\n";
  }

  /**
   * Given an array of <code>Tag</code>s representing this custom tag, return its string
   * representation.
   *
   * @param tags the array of <code>Tag</code>s representing of this custom tag.
   */
  public String toString(Tag[] tags) {
    if (tags.length == 0) {
      return "";
    } else if (tags.length == 1) {
      return this.toString(tags[0]);
    } else {
      String result = "\n<DT><B>" + this.getHeader() + "</B><DD>";
      result += " <ul>\n";
      for (int i = 0; i < tags.length; i++) {
        result += "  <li> " + tags[i].text() + "\n";
      }
      return result + " </ul>\n</DD>\n";
    }
  }
}
