package javadoc331;

import com.sun.javadoc.*;
import com.sun.tools.doclets.Taglet;
import java.util.Map;
import java.util.StringTokenizer;

/** Implements the {@code @spec.derivedfield} tag for use in method specifications. */
public class DerivedfieldTaglet implements Taglet {
  public String getName() {
    return "spec.derivedfield";
  }

  public String getHeader() {
    return "Derived Fields";
  }

  public boolean inField() {
    return false;
  }

  public boolean inConstructor() {
    return false;
  }

  public boolean inMethod() {
    return false;
  }

  public boolean inOverview() {
    return false;
  }

  public boolean inPackage() {
    return false;
  }

  public boolean inType() {
    return true;
  }

  public boolean isInlineTag() {
    return false;
  }

  public static void register(Map<String, Taglet> map) {
    DerivedfieldTaglet derivedfieldtaglet = new DerivedfieldTaglet();
    Taglet taglet = map.get(derivedfieldtaglet.getName());
    if (taglet != null) map.remove(derivedfieldtaglet.getName());
    map.put(derivedfieldtaglet.getName(), derivedfieldtaglet);
  }

  protected static String formatText(String string) {
    StringBuffer stringbuffer = new StringBuffer();
    StringTokenizer stringtokenizer = new StringTokenizer(string, " \t\n\r", true);
    stringbuffer.append("<CODE>");
    stringbuffer.append(stringtokenizer.nextToken());
    stringbuffer.append("</CODE>");
    while (stringtokenizer.hasMoreTokens()) stringbuffer.append(stringtokenizer.nextToken());
    return stringbuffer.toString();
  }

  public String toString(Tag tag) {
    return ("<DT><B>" + getHeader() + ":</B><DD>" + formatText(tag.text()) + "</DD>\n");
  }

  public String toString(Tag[] tags) {
    if (tags.length == 0) {
      return "";
    }
    if (tags.length == 1) {
      return toString(tags[0]);
    }
    String string = "\n<DT><B>" + getHeader() + "</B><DD>";
    String string_0_ = string;
    StringBuffer stringbuffer = new StringBuffer();

    string = stringbuffer.append(string_0_).append(" <ul>\n").toString();
    for (int i = 0; i < tags.length; i++) {
      String string_1_ = string;
      StringBuffer stringbuffer_2_ = new StringBuffer();

      string =
          stringbuffer_2_
              .append(string_1_)
              .append("  <li> ")
              .append(formatText(tags[i].text()))
              .append('\n')
              .toString();
    }
    String string_3_ = string;
    StringBuffer stringbuffer_4_ = new StringBuffer();

    string = stringbuffer_4_.append(string_3_).append(" </ul>\n</DD>\n").toString();
    return string;
  }
}
