/*
 * Decompiled with CFR 0.152.
 */
package play.libs.reflect;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import play.libs.reflect.ClassUtils;
import play.libs.reflect.MemberUtils;

public class MethodUtils {
    public static Method getAccessibleMethod(Method method) {
        Class<?>[] classArray;
        if (!MemberUtils.isAccessible(method)) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        String string = method.getName();
        if ((method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, string, classArray = method.getParameterTypes())) == null) {
            method = MethodUtils.getAccessibleMethodFromSuperclass(clazz, string, classArray);
        }
        return method;
    }

    private static Method getAccessibleMethodFromSuperclass(Class<?> clazz, String string, Class<?> ... classArray) {
        for (Class<?> clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            if (!Modifier.isPublic(clazz2.getModifiers())) continue;
            try {
                return clazz2.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        return null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class<?> clazz, String string, Class<?> ... classArray) {
        while (clazz != null) {
            Class<?>[] classArray2;
            for (Class<?> clazz2 : classArray2 = clazz.getInterfaces()) {
                if (!Modifier.isPublic(clazz2.getModifiers())) continue;
                try {
                    return clazz2.getDeclaredMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Method method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz2, string, classArray);
                    if (method == null) continue;
                    return method;
                }
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Method getMatchingAccessibleMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            Method method = clazz.getMethod(string, classArray);
            MemberUtils.setAccessibleWorkaround(method);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Object object;
            Method method = null;
            Method[] methodArray = clazz.getMethods();
            for (Method object2 : methodArray) {
                if (!object2.getName().equals(string) || !MemberUtils.isMatchingMethod(object2, classArray) || (object = MethodUtils.getAccessibleMethod(object2)) == null || method != null && MemberUtils.compareMethodFit((Method)object, method, classArray) >= 0) continue;
                method = object;
            }
            if (method != null) {
                MemberUtils.setAccessibleWorkaround(method);
            }
            if (method != null && method.isVarArgs() && method.getParameterTypes().length > 0 && classArray.length > 0) {
                GenericDeclaration[] genericDeclarationArray = method.getParameterTypes();
                Class<?> clazz2 = ((Class)genericDeclarationArray[genericDeclarationArray.length - 1]).getComponentType();
                String string2 = ClassUtils.primitiveToWrapper(clazz2).getName();
                String string3 = classArray[classArray.length - 1].getName();
                object = classArray[classArray.length - 1].getSuperclass().getName();
                if (!string2.equals(string3) && !string2.equals(object)) {
                    return null;
                }
            }
            return method;
        }
    }
}

