/*
 * Decompiled with CFR 0.152.
 */
package play.api.mvc;

import java.io.Serializable;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Sink;
import play.api.libs.streams.Accumulator;
import play.api.libs.streams.Accumulator$;
import play.api.mvc.BodyParser;
import play.api.mvc.BodyParser$;
import play.api.mvc.BodyParserUtils$;
import play.api.mvc.BodyParsers;
import play.api.mvc.MaxSizeExceeded;
import play.api.mvc.MaxSizeExceeded$;
import play.api.mvc.MaxSizeStatus;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.core.Execution$;
import play.core.Execution$Implicits$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public interface BodyParserUtils {
    public static boolean contentLengthHeaderExceedsMaxLength(RequestHeader requestHeader, long l) {
        return BodyParserUtils$.MODULE$.contentLengthHeaderExceedsMaxLength(requestHeader, l);
    }

    public static BodyParser empty$(BodyParserUtils $this) {
        return $this.empty();
    }

    default public BodyParser<BoxedUnit> empty() {
        return this.ignore(BoxedUnit.UNIT);
    }

    public static BodyParser ignore$(BodyParserUtils $this, Object body) {
        return $this.ignore(body);
    }

    default public <A> BodyParser<A> ignore(A body) {
        return BodyParser$.MODULE$.apply("ignore", (Function1 & Serializable)request -> Accumulator$.MODULE$.done((Object)package$.MODULE$.Right().apply(body)));
    }

    public static BodyParser error$(BodyParserUtils $this, Future result) {
        return $this.error((Future<Result>)result);
    }

    default public <A> BodyParser<A> error(Future<Result> result) {
        return BodyParser$.MODULE$.apply("error", (Function1 & Serializable)_$6 -> Accumulator$.MODULE$.done(result.map((Function1 & Serializable)value -> package$.MODULE$.Left().apply(value), (ExecutionContext)Execution$.MODULE$.trampoline())));
    }

    public static BodyParser using$(BodyParserUtils $this, Function1 f) {
        return $this.using(f);
    }

    default public <A> BodyParser<A> using(Function1<RequestHeader, BodyParser<A>> f) {
        return BodyParser$.MODULE$.apply((Function1 & Serializable)request -> (Accumulator)((Function1)f.apply(request)).apply(request));
    }

    public static BodyParser flatten$(BodyParserUtils $this, Future underlying, ExecutionContext ec, Materializer mat) {
        return $this.flatten(underlying, ec, mat);
    }

    default public <A> BodyParser<A> flatten(Future<BodyParser<A>> underlying, ExecutionContext ec, Materializer mat) {
        return BodyParser$.MODULE$.apply((Function1 & Serializable)request -> Accumulator$.MODULE$.flatten(underlying.map((Function1 & Serializable)_$7 -> (Accumulator)_$7.apply(request), ec), mat));
    }

    public static BodyParser when$(BodyParserUtils $this, Function1 predicate, BodyParser parser, Function1 badResult) {
        return $this.when((Function1<RequestHeader, Object>)predicate, parser, (Function1<RequestHeader, Future<Result>>)badResult);
    }

    default public <A> BodyParser<A> when(Function1<RequestHeader, Object> predicate, BodyParser<A> parser, Function1<RequestHeader, Future<Result>> badResult) {
        return BodyParser$.MODULE$.apply("conditional, wrapping=" + parser, (Function1 & Serializable)request -> {
            if (BoxesRunTime.unboxToBoolean((Object)predicate.apply(request))) {
                return (Accumulator)parser.apply(request);
            }
            return Accumulator$.MODULE$.done(((Future)badResult.apply(request)).map((Function1 & Serializable)value -> package$.MODULE$.Left().apply(value), (ExecutionContext)Execution$.MODULE$.trampoline()));
        });
    }

    public static BodyParser maxLength$(BodyParserUtils $this, long maxLength, BodyParser parser, Materializer mat) {
        return $this.maxLength(maxLength, parser, mat);
    }

    default public <A> BodyParser<Either<MaxSizeExceeded, A>> maxLength(long maxLength, BodyParser<A> parser, Materializer mat) {
        return BodyParser$.MODULE$.apply("maxLength=" + maxLength + ", wrapping=" + parser, (Function1 & Serializable)request -> {
            if (BodyParserUtils$.MODULE$.contentLengthHeaderExceedsMaxLength((RequestHeader)request, maxLength)) {
                return Accumulator$.MODULE$.done(Future$.MODULE$.successful((Object)package$.MODULE$.Right().apply((Object)package$.MODULE$.Left().apply((Object)MaxSizeExceeded$.MODULE$.apply(maxLength)))));
            }
            Flow takeUpToFlow = Flow$.MODULE$.fromGraph((Graph)new BodyParsers.TakeUpTo(maxLength));
            Sink parserSink = ((Accumulator)parser.apply(request)).toSink();
            return Accumulator$.MODULE$.apply(takeUpToFlow.toMat((Graph)parserSink, (Function2 & Serializable)(statusFuture, resultFuture) -> statusFuture.flatMap((Function1 & Serializable)x$12 -> {
                MaxSizeStatus maxSizeStatus = x$12;
                if (maxSizeStatus instanceof MaxSizeExceeded) {
                    MaxSizeExceeded exceeded = (MaxSizeExceeded)maxSizeStatus;
                    return Future$.MODULE$.successful((Object)package$.MODULE$.Right().apply((Object)package$.MODULE$.Left().apply((Object)exceeded)));
                }
                return resultFuture.map((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Left) {
                        Result result = (Result)((Left)either).value();
                        return package$.MODULE$.Left().apply((Object)result);
                    }
                    if (either instanceof Right) {
                        Object a = ((Right)either).value();
                        return package$.MODULE$.Right().apply((Object)package$.MODULE$.Right().apply(a));
                    }
                    throw new MatchError((Object)either);
                }, (ExecutionContext)Execution$Implicits$.MODULE$.trampoline());
            }, (ExecutionContext)Execution$Implicits$.MODULE$.trampoline())));
        });
    }
}

