/*
 * Decompiled with CFR 0.152.
 */
package play.utils;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.runtime.ModuleSerializationProxy;

public final class Resources$
implements Serializable {
    public static final Resources$ MODULE$ = new Resources$();

    private Resources$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Resources$.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDirectory(ClassLoader classLoader, URL url) {
        String string = url.getProtocol();
        switch (string == null ? 0 : string.hashCode()) {
            case -1377881982: {
                if ("bundle".equals(string)) return this.isBundleResourceDirectory(classLoader, url);
                throw new IllegalArgumentException("Cannot check isDirectory for a URL with protocol='" + url.getProtocol() + "'");
            }
            case -341064690: {
                if (!"resource".equals(string)) throw new IllegalArgumentException("Cannot check isDirectory for a URL with protocol='" + url.getProtocol() + "'");
                return this.isGraalVMResourceDirectory(classLoader, url);
            }
            case 104987: {
                if (!"jar".equals(string)) throw new IllegalArgumentException("Cannot check isDirectory for a URL with protocol='" + url.getProtocol() + "'");
                return this.isZipResourceDirectory(url);
            }
            case 120609: {
                if (!"zip".equals(string)) throw new IllegalArgumentException("Cannot check isDirectory for a URL with protocol='" + url.getProtocol() + "'");
                return this.isZipResourceDirectory(url);
            }
            case 3143036: {
                if (!"file".equals(string)) throw new IllegalArgumentException("Cannot check isDirectory for a URL with protocol='" + url.getProtocol() + "'");
                return new File(url.toURI()).isDirectory();
            }
            case 1780175504: {
                if (!"bundleresource".equals(string)) throw new IllegalArgumentException("Cannot check isDirectory for a URL with protocol='" + url.getProtocol() + "'");
                return this.isBundleResourceDirectory(classLoader, url);
            }
        }
        throw new IllegalArgumentException("Cannot check isDirectory for a URL with protocol='" + url.getProtocol() + "'");
    }

    public boolean isUrlConnectionADirectory(URLConnection urlConnection) {
        return this.isUrlConnectionADirectory(null, urlConnection);
    }

    public boolean isUrlConnectionADirectory(ClassLoader classLoader, URLConnection urlConnection) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)urlConnection, (Object)urlConnection.getURL().getProtocol());
        if (tuple2 != null) {
            URLConnection uRLConnection = (URLConnection)tuple2._1();
            String string = (String)tuple2._2();
            URLConnection file = uRLConnection;
            if ("file".equals(string)) {
                return new File(file.getURL().toURI()).isDirectory();
            }
            if (uRLConnection instanceof JarURLConnection) {
                JarURLConnection jar = (JarURLConnection)uRLConnection;
                return this.isJarURLConnectionDirectory(jar);
            }
            URLConnection bundle = uRLConnection;
            if ("bundle".equals(string)) {
                return this.isBundleResourceDirectory(classLoader, bundle);
            }
            URLConnection bundleResource = uRLConnection;
            if ("bundleresource".equals(string)) {
                return this.isBundleResourceDirectory(classLoader, bundleResource);
            }
            URLConnection resource = uRLConnection;
            if ("resource".equals(string)) {
                return this.isGraalVMResourceDirectory(classLoader, resource);
            }
        }
        return false;
    }

    public void closeUrlConnection(URLConnection connection) {
        URLConnection uRLConnection = connection;
        if (uRLConnection instanceof JarURLConnection) {
            JarURLConnection jar = (JarURLConnection)uRLConnection;
            if (!jar.getUseCaches()) {
                jar.getJarFile().close();
                return;
            }
            return;
        }
        URLConnection other = uRLConnection;
        other.getInputStream().close();
    }

    private boolean isZipResourceDirectory(URL url) {
        boolean bl;
        String path = url.getPath();
        int bangIndex = url.getFile().indexOf("!");
        int startIndex = path.startsWith("zip:") ? 4 : 0;
        String fileUri = path.substring(startIndex, bangIndex);
        String fileProtocol = fileUri.startsWith("/") ? "file://" : "";
        String absoluteFileUri = fileProtocol + fileUri;
        File zipFile = new File(URI.create(absoluteFileUri));
        String resourcePath = StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(URI.create(path.substring(bangIndex + 1)).getPath()), 1);
        try (ZipFile zip = new ZipFile(zipFile);){
            ZipEntry entry = zip.getEntry(resourcePath);
            if (entry.isDirectory()) {
                bl = true;
            } else {
                boolean isDir;
                InputStream stream = zip.getInputStream(entry);
                boolean bl2 = isDir = stream == null;
                if (stream != null) {
                    stream.close();
                }
                bl = isDir;
            }
        }
        return bl;
    }

    private boolean isJarURLConnectionDirectory(JarURLConnection jar) {
        if (jar.getJarEntry().isDirectory()) {
            return true;
        }
        InputStream is = jar.getJarFile().getInputStream(jar.getJarEntry());
        if (is == null) {
            return true;
        }
        is.close();
        return false;
    }

    private boolean isBundleResourceDirectory(ClassLoader classLoader, URLConnection urlConnection) {
        return this.isBundleResourceDirectory(classLoader, urlConnection.getURL());
    }

    private boolean isBundleResourceDirectory(ClassLoader classLoader, URL url) {
        if (classLoader != null) {
            String path = url.getPath();
            String pathSlash = StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(path)) == '/' ? path : path + '/';
            return classLoader.getResource(path) != null && classLoader.getResource(pathSlash) != null;
        }
        return false;
    }

    private boolean isGraalVMResourceDirectory(ClassLoader classLoader, URLConnection urlConnection) {
        return this.isGraalVMResourceDirectory(classLoader, urlConnection.getURL());
    }

    private boolean isGraalVMResourceDirectory(ClassLoader classLoader, URL url) {
        return this.isBundleResourceDirectory(classLoader, url);
    }
}

