/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.apache.pekko.stream.javadsl.Flow;
import org.apache.pekko.util.ByteString;
import play.api.http.websocket.CloseCodes;
import play.http.websocket.Message;
import play.libs.F;
import play.libs.Json;
import play.libs.Scala;
import play.libs.streams.PekkoStreams;
import play.mvc.Http;
import play.mvc.Result;
import scala.PartialFunction;

public abstract class WebSocket {
    public static final MappedWebSocketAcceptor<String, String> Text = new MappedWebSocketAcceptor(Scala.partialFunction(message -> {
        if (message instanceof Message.Text) {
            return F.Either.Left(((Message.Text)message).data());
        }
        if (message instanceof Message.Binary) {
            return F.Either.Right(new Message.Close(CloseCodes.Unacceptable(), "This websocket only accepts text frames"));
        }
        throw Scala.noMatch();
    }), Message.Text::new);
    public static final MappedWebSocketAcceptor<ByteString, ByteString> Binary = new MappedWebSocketAcceptor(Scala.partialFunction(message -> {
        if (message instanceof Message.Binary) {
            return F.Either.Left(((Message.Binary)message).data());
        }
        if (message instanceof Message.Text) {
            return F.Either.Right(new Message.Close(CloseCodes.Unacceptable(), "This websocket only accepts binary frames"));
        }
        throw Scala.noMatch();
    }), Message.Binary::new);
    public static final MappedWebSocketAcceptor<JsonNode, JsonNode> Json = new MappedWebSocketAcceptor(Scala.partialFunction(message -> {
        try {
            if (message instanceof Message.Binary) {
                return F.Either.Left(play.libs.Json.parse(((Message.Binary)message).data().iterator().asInputStream()));
            }
            if (message instanceof Message.Text) {
                return F.Either.Left(play.libs.Json.parse(((Message.Text)message).data()));
            }
        }
        catch (RuntimeException runtimeException) {
            return F.Either.Right(new Message.Close(CloseCodes.Unacceptable(), "Unable to parse JSON message"));
        }
        throw Scala.noMatch();
    }), jsonNode -> new Message.Text(play.libs.Json.stringify(jsonNode)));

    public abstract CompletionStage<F.Either<Result, Flow<Message, Message, ?>>> apply(Http.RequestHeader var1);

    public static <In, Out> MappedWebSocketAcceptor<In, Out> json(Class<In> clazz) {
        return new MappedWebSocketAcceptor(Scala.partialFunction(message -> {
            try {
                if (message instanceof Message.Binary) {
                    return F.Either.Left(play.libs.Json.mapper().readValue(((Message.Binary)message).data().iterator().asInputStream(), clazz));
                }
                if (message instanceof Message.Text) {
                    return F.Either.Left(play.libs.Json.mapper().readValue(((Message.Text)message).data(), clazz));
                }
            }
            catch (Exception exception) {
                return F.Either.Right(new Message.Close(CloseCodes.Unacceptable(), exception.getMessage()));
            }
            throw Scala.noMatch();
        }), object -> {
            try {
                return new Message.Text(play.libs.Json.mapper().writeValueAsString(object));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    private static <In, Out> WebSocket acceptOrResult(final PartialFunction<Message, F.Either<In, Message>> partialFunction, final Function<Http.RequestHeader, CompletionStage<F.Either<Result, Flow<In, Out, ?>>>> function, final Function<Out, Message> function2) {
        return new WebSocket(){

            @Override
            public CompletionStage<F.Either<Result, Flow<Message, Message, ?>>> apply(Http.RequestHeader requestHeader) {
                return ((CompletionStage)function.apply(requestHeader)).thenApply(either -> {
                    if (either.left.isPresent()) {
                        return F.Either.Left((Result)either.left.get());
                    }
                    Flow flow = PekkoStreams.bypassWith(Flow.create().collect(partialFunction), play.api.libs.streams.PekkoStreams.onlyFirstCanFinishMerge((int)2), ((Flow)either.right.get()).map(function2::apply));
                    return F.Either.Right(flow);
                });
            }
        };
    }

    public static class MappedWebSocketAcceptor<In, Out> {
        private final PartialFunction<Message, F.Either<In, Message>> inMapper;
        private final Function<Out, Message> outMapper;

        public MappedWebSocketAcceptor(PartialFunction<Message, F.Either<In, Message>> partialFunction, Function<Out, Message> function) {
            this.inMapper = partialFunction;
            this.outMapper = function;
        }

        public WebSocket acceptOrResult(Function<Http.RequestHeader, CompletionStage<F.Either<Result, Flow<In, Out, ?>>>> function) {
            return WebSocket.acceptOrResult(this.inMapper, function, this.outMapper);
        }

        public WebSocket accept(Function<Http.RequestHeader, Flow<In, Out, ?>> function) {
            return this.acceptOrResult(requestHeader -> CompletableFuture.completedFuture(F.Either.Right((Flow)function.apply((Http.RequestHeader)requestHeader))));
        }
    }
}

