/*
 * Decompiled with CFR 0.152.
 */
package play.core.parsers;

import java.io.Serializable;
import java.nio.file.Files;
import org.apache.pekko.stream.ActorAttributes$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.IOResult;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Supervision$;
import org.apache.pekko.stream.scaladsl.FileIO$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.SubFlow;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import play.api.http.HttpErrorHandler;
import play.api.http.Status$;
import play.api.libs.Files;
import play.api.libs.streams.Accumulator;
import play.api.libs.streams.Accumulator$;
import play.api.mvc.BodyParser;
import play.api.mvc.BodyParser$;
import play.api.mvc.MultipartFormData;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.core.Execution$Implicits$;
import play.core.parsers.Multipart;
import play.core.parsers.Multipart$NotEnoughDataException$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.matching.Regex;

public final class Multipart$ {
    public static final Multipart$ MODULE$ = new Multipart$();
    private static final Regex play$core$parsers$Multipart$$KeyValue = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([a-zA-Z_0-9]+)=\"?(.*?)\"?$"));
    private static final Regex play$core$parsers$Multipart$$ExtendedKeyValue = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([a-zA-Z_0-9]+)\\*=(.*?)'.*'(.*?)$"));
    private static final ByteString play$core$parsers$Multipart$$crlfcrlf = ByteString$.MODULE$.apply("\r\n\r\n");

    private final int maxHeaderBuffer() {
        return 4096;
    }

    public Regex play$core$parsers$Multipart$$KeyValue() {
        return play$core$parsers$Multipart$$KeyValue;
    }

    public Regex play$core$parsers$Multipart$$ExtendedKeyValue() {
        return play$core$parsers$Multipart$$ExtendedKeyValue;
    }

    public <A> BodyParser<A> partParser(long maxMemoryBufferSize, HttpErrorHandler errorHandler, Accumulator<MultipartFormData.Part<Source<ByteString, ?>>, Either<Result, A>> partHandler, Materializer mat) {
        return this.partParser(maxMemoryBufferSize, false, errorHandler, partHandler, mat);
    }

    public <A> BodyParser<A> partParser(long maxMemoryBufferSize, boolean allowEmptyFiles, HttpErrorHandler errorHandler, Accumulator<MultipartFormData.Part<Source<ByteString, ?>>, Either<Result, A>> partHandler, Materializer mat) {
        return BodyParser$.MODULE$.apply((Function1 & Serializable)request -> {
            Option maybeBoundary = request.mediaType().flatMap((Function1 & Serializable)mt -> mt.parameters().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Multipart$.$anonfun$partParser$3(x$1))).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Multipart$.$anonfun$partParser$4(check$ifrefutable$1))).flatMap((Function1 & Serializable)x$2 -> {
                Tuple2 tuple2 = x$2;
                if (tuple2 != null) {
                    Option value = (Option)tuple2._2();
                    return value.map((Function1 & Serializable)boundary -> boundary);
                }
                throw new MatchError((Object)tuple2);
            }));
            return (Accumulator)maybeBoundary.map((Function1 & Serializable)boundary -> {
                Flow multipartFlow = ((Flow)((SubFlow)Flow$.MODULE$.apply().via((Graph)new Multipart.BodyPartParser((String)boundary, maxMemoryBufferSize, 4096, allowEmptyFiles)).splitWhen((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isLeft())).prefixAndTail(1).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Left left;
                        MultipartFormData.Part part;
                        Either either;
                        SeqOps seqOps;
                        Seq seq = (Seq)tuple2._1();
                        Source body = (Source)tuple2._2();
                        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (either = (Either)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof Left && (part = (MultipartFormData.Part)(left = (Left)either).value()) instanceof MultipartFormData.FilePart) {
                            MultipartFormData.FilePart filePart = (MultipartFormData.FilePart)part;
                            Source x$1 = (Source)body.collect((PartialFunction)new Serializable(){
                                private static final long serialVersionUID = 0L;

                                public final <A1 extends Either<MultipartFormData.Part<BoxedUnit>, ByteString>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                    A1 A1 = x1;
                                    if (A1 instanceof Right) {
                                        Right right = (Right)A1;
                                        ByteString bytes = (ByteString)right.value();
                                        return (B1)bytes;
                                    }
                                    return (B1)function1.apply(x1);
                                }

                                public final boolean isDefinedAt(Either<MultipartFormData.Part<BoxedUnit>, ByteString> x1) {
                                    Either<MultipartFormData.Part<BoxedUnit>, ByteString> either = x1;
                                    return either instanceof Right;
                                }
                            });
                            Function1 & Serializable x$2 = (Function1 & Serializable)byteSource -> new Some(Await$.MODULE$.result((Awaitable)byteSource.runFold((Object)ByteString$.MODULE$.empty(), (Function2 & Serializable)(x$4, x$5) -> x$4.$plus$plus(x$5), mat), (Duration)Duration$.MODULE$.Inf()));
                            String x$3 = filePart.copy$default$1();
                            String x$4 = filePart.copy$default$2();
                            Option<String> x$5 = filePart.copy$default$3();
                            long x$6 = filePart.copy$default$5();
                            String x$7 = filePart.copy$default$6();
                            return filePart.copy(x$3, x$4, x$5, x$1, x$6, x$7, x$2);
                        }
                    }
                    if (tuple2 != null) {
                        Either either;
                        SeqOps seqOps;
                        Seq seq = (Seq)tuple2._1();
                        Source ignored = (Source)tuple2._2();
                        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (either = (Either)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof Left) {
                            Left left = (Left)either;
                            MultipartFormData.Part other = (MultipartFormData.Part)left.value();
                            ignored.runWith((Graph)Sink$.MODULE$.cancelled(), mat);
                            return other;
                        }
                    }
                    throw new MatchError((Object)tuple2);
                })).concatSubstreams()).withAttributes(ActorAttributes$.MODULE$.supervisionStrategy(Supervision$.MODULE$.resumingDecider()));
                return partHandler.through(multipartFlow);
            }).getOrElse((Function0 & Serializable)() -> {
                String x$8 = "Missing boundary header";
                HttpErrorHandler x$9 = errorHandler;
                int x$10 = MODULE$.play$core$parsers$Multipart$$createBadResult$default$2();
                return Accumulator$.MODULE$.done((Future)MODULE$.play$core$parsers$Multipart$$createBadResult("Missing boundary header", x$10, x$9).apply(request));
            });
        });
    }

    public <A> BodyParser<MultipartFormData<A>> multipartParser(long maxMemoryBufferSize, Function1<Multipart.FileInfo, Accumulator<ByteString, MultipartFormData.FilePart<A>>> filePartHandler, HttpErrorHandler errorHandler, Materializer mat) {
        return this.multipartParser(maxMemoryBufferSize, false, filePartHandler, errorHandler, mat);
    }

    public <A> BodyParser<MultipartFormData<A>> multipartParser(long maxMemoryBufferSize, boolean allowEmptyFiles, Function1<Multipart.FileInfo, Accumulator<ByteString, MultipartFormData.FilePart<A>>> filePartHandler, HttpErrorHandler errorHandler, Materializer mat) {
        return BodyParser$.MODULE$.apply((Function1 & Serializable)request -> {
            Flow handleFileParts = (Flow)Flow$.MODULE$.apply().mapAsync(1, (Function1 & Serializable)x0$1 -> {
                MultipartFormData.Part part = x0$1;
                if (part instanceof MultipartFormData.FilePart) {
                    MultipartFormData.FilePart filePart = (MultipartFormData.FilePart)part;
                    return ((Accumulator)filePartHandler.apply((Object)new Multipart.FileInfo(filePart.key(), filePart.filename(), filePart.contentType(), filePart.dispositionType()))).run((Source)filePart.ref(), mat);
                }
                if (part instanceof MultipartFormData.Part) {
                    MultipartFormData.Part part2 = part;
                    return Future$.MODULE$.successful((Object)part2);
                }
                throw new MatchError((Object)part);
            });
            Accumulator multipartAccumulator = Accumulator$.MODULE$.apply(Sink$.MODULE$.fold((Object)package$.MODULE$.Vector().empty(), (Function2 & Serializable)(x$6, x$7) -> (Seq)x$6.$colon$plus(x$7))).mapFuture((Function1 & Serializable)parts -> (Future)Multipart$.parseError$1(parts, errorHandler, request).orElse((Function0 & Serializable)() -> Multipart$.bufferExceededError$1(parts, errorHandler, request)).getOrElse((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)new Right(new MultipartFormData((Map<String, Seq<String>>)((Map)((IterableOps)parts.collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends MultipartFormData.Part<A>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof MultipartFormData.DataPart) {
                        MultipartFormData.DataPart dataPart = (MultipartFormData.DataPart)A1;
                        return (B1)dataPart;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(MultipartFormData.Part<A> x1) {
                    MultipartFormData.Part<A> part = x1;
                    return part instanceof MultipartFormData.DataPart;
                }
            })).groupBy((Function1 & Serializable)x$8 -> x$8.key()).map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Seq partValues = (Seq)tuple2._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), partValues.map((Function1 & Serializable)x$9 -> x$9.value()));
                }
                throw new MatchError((Object)tuple2);
            })), (Seq)parts.collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends MultipartFormData.Part<A>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 instanceof MultipartFormData.FilePart) {
                        MultipartFormData.FilePart filePart = (MultipartFormData.FilePart)A1;
                        return (B1)filePart;
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(MultipartFormData.Part<A> x2) {
                    MultipartFormData.Part<A> part = x2;
                    return part instanceof MultipartFormData.FilePart;
                }
            }), (Seq<MultipartFormData.BadPart>)((Seq)parts.collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends MultipartFormData.Part<A>, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    if (A1 instanceof MultipartFormData.BadPart) {
                        MultipartFormData.BadPart badPart = (MultipartFormData.BadPart)A1;
                        return (B1)badPart;
                    }
                    return (B1)function1.apply(x3);
                }

                public final boolean isDefinedAt(MultipartFormData.Part<A> x3) {
                    MultipartFormData.Part<A> part = x3;
                    return part instanceof MultipartFormData.BadPart;
                }
            })))))), (ExecutionContext)Execution$Implicits$.MODULE$.trampoline());
            return (Accumulator)MODULE$.partParser(maxMemoryBufferSize, allowEmptyFiles, errorHandler, multipartAccumulator.through(handleFileParts), mat).apply(request);
        });
    }

    public Function1<Multipart.FileInfo, Accumulator<ByteString, MultipartFormData.FilePart<Files.TemporaryFile>>> handleFilePartAsTemporaryFile(Files.TemporaryFileCreator temporaryFileCreator) {
        return (Function1 & Serializable)x0$1 -> {
            Multipart.FileInfo fileInfo = x0$1;
            if (fileInfo != null) {
                String partName = fileInfo.partName();
                String filename = fileInfo.fileName();
                Option<String> contentType = fileInfo.contentType();
                String dispositionType = fileInfo.dispositionType();
                Files.TemporaryFile tempFile = temporaryFileCreator.create("multipartBody", "asTemporaryFile");
                return Accumulator$.MODULE$.apply(FileIO$.MODULE$.toPath(tempFile.path(), FileIO$.MODULE$.toPath$default$2())).mapFuture((Function1 & Serializable)x0$2 -> {
                    IOResult iOResult;
                    IOResult iOResult2;
                    IOResult iOResult3 = x0$2;
                    if (iOResult3 != null && (iOResult2 = iOResult3).status().isFailure()) {
                        return Future$.MODULE$.failed((Throwable)iOResult2.status().failed().get());
                    }
                    if (iOResult3 != null && (iOResult = iOResult3).status().isSuccess()) {
                        return Future$.MODULE$.successful(new MultipartFormData.FilePart<Files.TemporaryFile>(partName, filename, contentType, tempFile, iOResult.count(), dispositionType, (Function1 & Serializable)tf -> new Some((Object)ByteString$.MODULE$.fromArray(Files.readAllBytes(tf.path())))));
                    }
                    throw new MatchError((Object)iOResult3);
                }, (ExecutionContext)Execution$Implicits$.MODULE$.trampoline());
            }
            throw new MatchError((Object)fileInfo);
        };
    }

    public <A> Function1<RequestHeader, Future<Either<Result, A>>> play$core$parsers$Multipart$$createBadResult(String msg, int status, HttpErrorHandler errorHandler) {
        return (Function1 & Serializable)request -> errorHandler.onClientError((RequestHeader)request, status, msg).map((Function1 & Serializable)x$18 -> new Left(x$18), (ExecutionContext)Execution$Implicits$.MODULE$.trampoline());
    }

    public <A> int play$core$parsers$Multipart$$createBadResult$default$2() {
        return Status$.MODULE$.BAD_REQUEST();
    }

    public char play$core$parsers$Multipart$$byteChar(ByteString input2, int ix) {
        return (char)this.play$core$parsers$Multipart$$byteAt(input2, ix);
    }

    public byte play$core$parsers$Multipart$$byteAt(ByteString input2, int ix) {
        if (ix < input2.length()) {
            return input2.apply(ix);
        }
        throw Multipart$NotEnoughDataException$.MODULE$;
    }

    public ByteString play$core$parsers$Multipart$$crlfcrlf() {
        return play$core$parsers$Multipart$$crlfcrlf;
    }

    public static final /* synthetic */ boolean $anonfun$partParser$3(Tuple2 x$1) {
        return ((String)x$1._1()).equalsIgnoreCase("boundary");
    }

    public static final /* synthetic */ boolean $anonfun$partParser$4(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    private static final Option parseError$1(Seq parts$1, HttpErrorHandler errorHandler$2, RequestHeader request$2) {
        return parts$1.collectFirst((PartialFunction)new Serializable(errorHandler$2, request$2){
            private static final long serialVersionUID = 0L;
            private final HttpErrorHandler errorHandler$2;
            private final RequestHeader request$2;

            public final <A1 extends MultipartFormData.Part<A>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof MultipartFormData.ParseError) {
                    String msg;
                    MultipartFormData.ParseError parseError2 = (MultipartFormData.ParseError)A1;
                    String x$1 = msg = parseError2.message();
                    HttpErrorHandler x$2 = this.errorHandler$2;
                    int x$3 = Multipart$.MODULE$.play$core$parsers$Multipart$$createBadResult$default$2();
                    return (B1)Multipart$.MODULE$.play$core$parsers$Multipart$$createBadResult(x$1, x$3, x$2).apply((Object)this.request$2);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(MultipartFormData.Part<A> x1) {
                MultipartFormData.Part<A> part = x1;
                return part instanceof MultipartFormData.ParseError;
            }
            {
                this.errorHandler$2 = errorHandler$2;
                this.request$2 = request$2;
            }
        });
    }

    private static final Option bufferExceededError$1(Seq parts$1, HttpErrorHandler errorHandler$2, RequestHeader request$2) {
        return parts$1.collectFirst((PartialFunction)new Serializable(errorHandler$2, request$2){
            private static final long serialVersionUID = 0L;
            private final HttpErrorHandler errorHandler$2;
            private final RequestHeader request$2;

            public final <A1 extends MultipartFormData.Part<A>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof MultipartFormData.MaxMemoryBufferExceeded) {
                    MultipartFormData.MaxMemoryBufferExceeded maxMemoryBufferExceeded = (MultipartFormData.MaxMemoryBufferExceeded)A1;
                    String msg = maxMemoryBufferExceeded.message();
                    return (B1)Multipart$.MODULE$.play$core$parsers$Multipart$$createBadResult(msg, Status$.MODULE$.REQUEST_ENTITY_TOO_LARGE(), this.errorHandler$2).apply((Object)this.request$2);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(MultipartFormData.Part<A> x1) {
                MultipartFormData.Part<A> part = x1;
                return part instanceof MultipartFormData.MaxMemoryBufferExceeded;
            }
            {
                this.errorHandler$2 = errorHandler$2;
                this.request$2 = request$2;
            }
        });
    }

    private Multipart$() {
    }
}

