/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.concurrent;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueFactory;
import java.io.Serializable;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystem$;
import org.apache.pekko.actor.BootstrapSetup;
import org.apache.pekko.actor.BootstrapSetup$;
import org.apache.pekko.actor.setup.ActorSystemSetup;
import org.apache.pekko.actor.setup.ActorSystemSetup$;
import org.apache.pekko.actor.setup.Setup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.libs.concurrent.ActorSystemProvider;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class ActorSystemProvider$ {
    public static final ActorSystemProvider$ MODULE$ = new ActorSystemProvider$();
    private static final Logger logger = LoggerFactory.getLogger(ActorSystemProvider.class);

    private Logger logger() {
        return logger;
    }

    public ActorSystem start(ClassLoader classLoader, Configuration config) {
        return this.start(classLoader, config, (Seq<Setup>)Nil$.MODULE$);
    }

    public ActorSystem start(ClassLoader classLoader, Configuration config, Setup additionalSetup) {
        return this.start(classLoader, config, (Seq<Setup>)new .colon.colon((Object)additionalSetup, (List)Nil$.MODULE$));
    }

    public ActorSystem start(ClassLoader classLoader, Configuration config, Seq<Setup> additionalSetups) {
        BootstrapSetup bootstrapSetup;
        String exitJvmPath = "pekko.coordinated-shutdown.exit-jvm";
        if (BoxesRunTime.unboxToBoolean((Object)config.get(exitJvmPath, ConfigLoader$.MODULE$.booleanLoader()))) {
            String errorMessage = "Can't start Play: detected \"" + exitJvmPath + " = on\". Using \"" + exitJvmPath + " = on\" in Play may cause a deadlock when shutting down. Please set \"" + exitJvmPath + " = off\"";
            this.logger().error(errorMessage);
            throw config.reportError(exitJvmPath, errorMessage, config.reportError$default$3());
        }
        String playTimeoutKey = "play.pekko.shutdown-timeout";
        Duration playTimeoutDuration = (Duration)Try$.MODULE$.apply((Function0 & Serializable)() -> (Duration)config.get(playTimeoutKey, ConfigLoader$.MODULE$.durationLoader())).getOrElse((Function0 & Serializable)() -> Duration$.MODULE$.Inf());
        int pekkoMaxDelay = 2147483;
        FiniteDuration pekkoMaxDuration = Duration$.MODULE$.apply((long)pekkoMaxDelay, "seconds");
        Duration normalisedDuration = playTimeoutDuration.min((Duration)pekkoMaxDuration);
        java.time.Duration pekkoTimeoutDuration = java.time.Duration.ofMillis(normalisedDuration.toMillis());
        String pekkoTimeoutKey = "pekko.coordinated-shutdown.phases.actor-system-terminate.timeout";
        Config pekkoConfig = config.underlying().withValue(pekkoTimeoutKey, ConfigValueFactory.fromAnyRef((Object)pekkoTimeoutDuration));
        String name = (String)config.get("play.pekko.actor-system", ConfigLoader$.MODULE$.stringLoader());
        BootstrapSetup bootstrapSetup2 = bootstrapSetup = BootstrapSetup$.MODULE$.apply((Option)new Some((Object)classLoader), (Option)new Some((Object)pekkoConfig), (Option)None$.MODULE$);
        ActorSystemSetup actorSystemSetup = ActorSystemSetup$.MODULE$.apply((Seq)additionalSetups.$plus$colon((Object)bootstrapSetup2));
        this.logger().debug("Starting application default Pekko system: " + name);
        return ActorSystem$.MODULE$.apply(name, actorSystemSetup);
    }

    private ActorSystemProvider$() {
    }
}

