/*
 * Decompiled with CFR 0.152.
 */
package play.utils;

import java.io.File;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;

public final class Resources$ {
    public static final Resources$ MODULE$ = new Resources$();

    public boolean isDirectory(ClassLoader classLoader, URL url) {
        block14: {
            String string = url.getProtocol();
            switch (string == null ? 0 : string.hashCode()) {
                case -1377881982: {
                    if ("bundle".equals(string)) {
                        break;
                    }
                    break block14;
                }
                case -341064690: {
                    if ("resource".equals(string)) {
                        return this.isGraalVMResourceDirectory(classLoader, url);
                    }
                    break block14;
                }
                case 104987: {
                    if ("jar".equals(string)) {
                        return this.isZipResourceDirectory(url);
                    }
                    break block14;
                }
                case 120609: {
                    if ("zip".equals(string)) {
                        return this.isZipResourceDirectory(url);
                    }
                    break block14;
                }
                case 3143036: {
                    if ("file".equals(string)) {
                        return new File(url.toURI()).isDirectory();
                    }
                    break block14;
                }
                case 1780175504: {
                    if ("bundleresource".equals(string)) {
                        break;
                    }
                    break block14;
                }
                default: {
                    break block14;
                }
            }
            return this.isBundleResourceDirectory(classLoader, url);
        }
        throw new IllegalArgumentException("Cannot check isDirectory for a URL with protocol='" + url.getProtocol() + "'");
    }

    public boolean isUrlConnectionADirectory(URLConnection urlConnection) {
        return this.isUrlConnectionADirectory(null, urlConnection);
    }

    public boolean isUrlConnectionADirectory(ClassLoader classLoader, URLConnection urlConnection) {
        URLConnection jar;
        Tuple2 tuple2 = new Tuple2((Object)urlConnection, (Object)urlConnection.getURL().getProtocol());
        if (tuple2 != null) {
            URLConnection file = (URLConnection)tuple2._1();
            String string = (String)tuple2._2();
            if ("file".equals(string)) {
                return new File(file.getURL().toURI()).isDirectory();
            }
        }
        if (tuple2 != null && (jar = (URLConnection)tuple2._1()) instanceof JarURLConnection) {
            JarURLConnection jarURLConnection = (JarURLConnection)jar;
            return this.isJarURLConnectionDirectory(jarURLConnection);
        }
        if (tuple2 != null) {
            URLConnection bundle = (URLConnection)tuple2._1();
            String string = (String)tuple2._2();
            if ("bundle".equals(string)) {
                return this.isBundleResourceDirectory(classLoader, bundle);
            }
        }
        if (tuple2 != null) {
            URLConnection bundleResource = (URLConnection)tuple2._1();
            String string = (String)tuple2._2();
            if ("bundleresource".equals(string)) {
                return this.isBundleResourceDirectory(classLoader, bundleResource);
            }
        }
        if (tuple2 != null) {
            URLConnection resource = (URLConnection)tuple2._1();
            String string = (String)tuple2._2();
            if ("resource".equals(string)) {
                return this.isGraalVMResourceDirectory(classLoader, resource);
            }
        }
        return false;
    }

    public void closeUrlConnection(URLConnection connection) {
        URLConnection uRLConnection = connection;
        if (uRLConnection instanceof JarURLConnection) {
            JarURLConnection jarURLConnection = (JarURLConnection)uRLConnection;
            if (!jarURLConnection.getUseCaches()) {
                jarURLConnection.getJarFile().close();
                return;
            }
            return;
        }
        uRLConnection.getInputStream().close();
    }

    private boolean isZipResourceDirectory(URL url) {
        boolean bl;
        String path = url.getPath();
        int bangIndex = url.getFile().indexOf("!");
        int startIndex = path.startsWith("zip:") ? 4 : 0;
        String fileUri = path.substring(startIndex, bangIndex);
        String fileProtocol = fileUri.startsWith("/") ? "file://" : "";
        String absoluteFileUri = fileProtocol + fileUri;
        File zipFile = new File(URI.create(absoluteFileUri));
        String resourcePath = StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(URI.create(path.substring(bangIndex + 1)).getPath()), 1);
        try (ZipFile zip = new ZipFile(zipFile);){
            ZipEntry entry = zip.getEntry(resourcePath);
            if (entry.isDirectory()) {
                bl = true;
            } else {
                boolean isDir;
                InputStream stream = zip.getInputStream(entry);
                boolean bl2 = isDir = stream == null;
                if (stream != null) {
                    stream.close();
                }
                bl = isDir;
            }
        }
        return bl;
    }

    private boolean isJarURLConnectionDirectory(JarURLConnection jar) {
        if (jar.getJarEntry().isDirectory()) {
            return true;
        }
        InputStream is = jar.getJarFile().getInputStream(jar.getJarEntry());
        if (is == null) {
            return true;
        }
        is.close();
        return false;
    }

    private boolean isBundleResourceDirectory(ClassLoader classLoader, URLConnection urlConnection) {
        return this.isBundleResourceDirectory(classLoader, urlConnection.getURL());
    }

    private boolean isBundleResourceDirectory(ClassLoader classLoader, URL url) {
        if (classLoader != null) {
            String path = url.getPath();
            String pathSlash = StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(path)) == '/' ? path : path + '/';
            return classLoader.getResource(path) != null && classLoader.getResource(pathSlash) != null;
        }
        return false;
    }

    private boolean isGraalVMResourceDirectory(ClassLoader classLoader, URLConnection urlConnection) {
        return this.isGraalVMResourceDirectory(classLoader, urlConnection.getURL());
    }

    private boolean isGraalVMResourceDirectory(ClassLoader classLoader, URL url) {
        return this.isBundleResourceDirectory(classLoader, url);
    }

    private Resources$() {
    }
}

