/*
 * Decompiled with CFR 0.152.
 */
package play.api.test;

import com.typesafe.config.ConfigFactory;
import java.util.Map;
import org.apache.pekko.annotation.ApiMayChange;
import play.api.Configuration;
import play.api.Configuration$;
import play.api.test.HttpServerEndpointRecipe$;
import play.api.test.ServerEndpointRecipe;
import play.api.test.TestServer;
import play.core.server.ServerEndpoint;
import play.core.server.ServerEndpoint$;
import play.core.server.ServerProvider;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;

@ApiMayChange
public final class HttpServerEndpointRecipe
implements ServerEndpointRecipe {
    private final String description;
    private final ServerProvider serverProvider;
    private final Configuration extraServerConfiguration;
    private final Set<String> expectedHttpVersions;
    private final Option<String> expectedServerAttr;
    private final Option configuredHttpPort;
    private final Option configuredHttpsPort;
    private final Configuration serverConfiguration;

    public static Configuration $lessinit$greater$default$3() {
        return HttpServerEndpointRecipe$.MODULE$.$lessinit$greater$default$3();
    }

    public HttpServerEndpointRecipe(String description, ServerProvider serverProvider, Configuration extraServerConfiguration, Set<String> expectedHttpVersions, Option<String> expectedServerAttr) {
        this.description = description;
        this.serverProvider = serverProvider;
        this.extraServerConfiguration = extraServerConfiguration;
        this.expectedHttpVersions = expectedHttpVersions;
        this.expectedServerAttr = expectedServerAttr;
        this.configuredHttpPort = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0));
        this.configuredHttpsPort = None$.MODULE$;
        this.serverConfiguration = extraServerConfiguration;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public ServerProvider serverProvider() {
        return this.serverProvider;
    }

    @Override
    public Option<Object> configuredHttpPort() {
        return this.configuredHttpPort;
    }

    @Override
    public Option<Object> configuredHttpsPort() {
        return this.configuredHttpsPort;
    }

    @Override
    public Configuration serverConfiguration() {
        return this.serverConfiguration;
    }

    @Override
    public ServerEndpoint createEndpointFromServer(TestServer runningServer) {
        return ServerEndpoint$.MODULE$.apply(this.description(), "http", "localhost", BoxesRunTime.unboxToInt((Object)runningServer.runningHttpPort().get()), this.expectedHttpVersions, this.expectedServerAttr, (Option)None$.MODULE$);
    }

    @Override
    public HttpServerEndpointRecipe withDescription(String newDescription) {
        return new HttpServerEndpointRecipe(newDescription, this.serverProvider(), this.extraServerConfiguration, this.expectedHttpVersions, this.expectedServerAttr);
    }

    @Override
    public HttpServerEndpointRecipe withServerProvider(ServerProvider newProvider) {
        return new HttpServerEndpointRecipe(this.description(), newProvider, this.extraServerConfiguration, this.expectedHttpVersions, this.expectedServerAttr);
    }

    @Override
    public HttpServerEndpointRecipe withExtraServerConfiguration(scala.collection.immutable.Map<String, Object> extraConfig) {
        return new HttpServerEndpointRecipe(this.description(), this.serverProvider(), Configuration$.MODULE$.apply(ConfigFactory.parseMap((Map)CollectionConverters$.MODULE$.MapHasAsJava(extraConfig).asJava())).withFallback(this.serverConfiguration()), this.expectedHttpVersions, this.expectedServerAttr);
    }

    public String toString() {
        return "HttpServerEndpointRecipe(" + this.description() + ")";
    }
}

